/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.msrandom.witchery.entity.EntityNightmare;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.CreatureUtil;

public class BlockFlowingSpirit
extends BlockFluidClassic {
    protected final boolean nightmareBane;
    protected final boolean igniteSpiritPortals;
    protected final PotionEffect goodyEffect;
    protected final PotionEffect baddyEffect;

    public BlockFlowingSpirit(Fluid fluid, PotionEffect goodyEffect, PotionEffect baddyEffect, boolean nightmareBane, boolean igniteSpiritPortals) {
        super(fluid, Material.WATER);
        this.quantaPerBlock = 5;
        this.setHardness(100.0f);
        this.setLightOpacity(3);
        this.goodyEffect = goodyEffect;
        this.baddyEffect = baddyEffect;
        this.nightmareBane = nightmareBane;
        this.igniteSpiritPortals = igniteSpiritPortals;
    }

    public void onBlockAdded(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!(this.igniteSpiritPortals && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && world.getBlockState(pos.down()).getBlock() == Blocks.SNOW && (Integer)state.getValue((IProperty)LEVEL) == 0 && WitcheryBlocks.SPIRIT_PORTAL.tryToCreatePortal(world, pos))) {
            super.onBlockAdded(world, pos, state);
        }
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity != null) {
            EntityItem item;
            ItemStack stack;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)entity;
                if (CreatureUtil.isUndead((Entity)livingEntity) || CreatureUtil.isDemonic((Entity)livingEntity) || this.nightmareBane && livingEntity instanceof EntityNightmare) {
                    if (!livingEntity.isPotionActive(this.baddyEffect.getPotion())) {
                        livingEntity.addPotionEffect(new PotionEffect(this.baddyEffect));
                    }
                } else if (!livingEntity.isPotionActive(this.goodyEffect.getPotion())) {
                    livingEntity.addPotionEffect(new PotionEffect(this.goodyEffect));
                }
            } else if (this.nightmareBane && entity instanceof EntityItem && (stack = (item = (EntityItem)entity).getItem()).getItem() == WitcheryIngredientItems.DISTURBED_COTTON) {
                ItemStack newStack = new ItemStack((Block)WitcheryBlocks.WISPY_COTTON, stack.getCount());
                item.setItem(newStack);
            }
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        return !world.getBlockState(pos).getMaterial().isLiquid() && super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        return !world.getBlockState(pos).getMaterial().isLiquid() && super.displaceIfPossible(world, pos);
    }
}

