/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.jvm.functions.Function0;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityFetish;
import net.msrandom.witchery.infusion.spirit.InfusedSpiritEffect;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockFetish
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f);
    @Nullable
    private final Function0<BlockFetish> spectralVersion;

    public BlockFetish(@Nullable @Nullable Function0<@Nullable BlockFetish> spectralVersion) {
        super(Material.WOOD);
        this.spectralVersion = spectralVersion;
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setResistance(100000.0f);
        this.setHardness(3.5f);
        this.setSoundType(SoundType.WOOD);
    }

    public boolean isSpectral() {
        return this.spectralVersion == null;
    }

    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.isSpectral()) {
            super.getSubBlocks(tab, items);
            for (Map.Entry entry2 : InfusedSpiritEffect.REGISTRY) {
                ItemStack stack = new ItemStack((Block)this);
                if (!((InfusedSpiritEffect)entry2.getValue()).bindToItem(stack)) continue;
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag;
        super.addInformation(stack, worldIn, tooltip, flagIn);
        if (stack.hasTagCompound() && (tag = WitcheryUtils.getOrCreateTag(stack)).hasKey("SpiritEffect")) {
            String[] id = ResourceLocation.splitObjectName((String)tag.getString("SpiritEffect"));
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.format((String)("fetish." + id[0] + "." + id[1]), (Object[])new Object[0]));
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        if (this.isSpectral()) {
            return NULL_AABB;
        }
        return super.getCollisionBoundingBox(blockState, world, pos);
    }

    public float getBlockHardness(IBlockState blockState, World world, BlockPos pos) {
        return this.isSpectral() ? -1.0f : super.getBlockHardness(blockState, world, pos);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        WorldServer overworld;
        NBTTagCompound tag;
        TileEntityFetish tile;
        if (!stack.isEmpty() && (tile = WitcheryTileEntities.FETISH.getAt((IBlockAccess)world, pos)) != null && (tag = stack.getTagCompound()) != null) {
            InfusedSpiritEffect effect = (InfusedSpiritEffect)InfusedSpiritEffect.REGISTRY.get(new ResourceLocation(tag.getString("SpiritEffect")));
            if (tag.hasKey("Data")) {
                NBTTagCompound nbtTileData = tag.getCompoundTag("Data");
                tile.readSubDataFromNBT(nbtTileData);
            }
            tile.setEffect(effect);
        }
        if (!world.isRemote && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && (overworld = player.getServer().getWorld(0)).isAirBlock(pos)) {
            BlockFetish spectralBlock;
            BlockFetish blockFetish = spectralBlock = this.spectralVersion == null ? null : (BlockFetish)((Object)this.spectralVersion.invoke());
            if (spectralBlock != null) {
                state = this.getSpectralVersion(state, spectralBlock);
                overworld.setBlockState(pos, state);
                spectralBlock.onBlockPlacedBy((World)overworld, pos, state, player, stack);
            }
        }
    }

    protected IBlockState getSpectralVersion(IBlockState original, @NotNull BlockFetish spectralBlock) {
        return spectralBlock.getDefaultState();
    }

    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.onBlockHarvested(world, pos, state, player);
        if (!world.isRemote && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world)) {
            WorldServer overworld = player.getServer().getWorld(0);
            if (world.getBlockState(pos).getBlock() == this) {
                overworld.setBlockToAir(pos);
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityFetish tile = WitcheryTileEntities.FETISH.getAt(world, pos);
        if (tile != null) {
            ItemStack stack = new ItemStack(tile.getBlockType());
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByte("BlockColor", (byte)tile.getColor());
            tag.setString("SpiritEffect", ((ResourceLocation)InfusedSpiritEffect.REGISTRY.getKey(tile.getEffect())).toString());
            NBTTagCompound nbtTileData = new NBTTagCompound();
            tile.writeSubDataToNBT(nbtTileData);
            tag.setTag("Data", (NBTBase)nbtTileData);
            stack.setTagCompound(tag);
            drops.add((Object)stack);
        }
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer getRenderLayer() {
        return this.isSpectral() ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    public Item getItemDropped(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        TileEntityFetish tile = WitcheryTileEntities.FETISH.getAt((IBlockAccess)world, pos);
        if (tile != null && player != null && !(stack = player.getHeldItem(hand)).isEmpty()) {
            if (!this.isSpectral()) {
                if (stack.getItem() == Items.DYE) {
                    int color2 = EnumDyeColor.byDyeDamage((int)stack.getItemDamage()).getDyeDamage();
                    tile.setColor(color2);
                    if (!player.capabilities.isCreativeMode) {
                        stack.shrink(1);
                        if (stack.isEmpty()) {
                            player.inventory.setInventorySlotContents(player.inventory.currentItem, ItemStack.EMPTY);
                        }
                    }
                    return true;
                }
                if (stack.getItem() == Items.WATER_BUCKET) {
                    tile.clearBoundEntities(stack, player);
                    world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    return true;
                }
                if (stack.getItem() == WitcheryGeneralItems.BOLINE) {
                    tile.cycleBoundMode(player);
                    return true;
                }
            }
            if (stack.getItem() == WitcheryGeneralItems.BOUND_TAGLOCK_KIT) {
                tile.setBoundEntity(stack, player, this.spectralVersion == null);
                return true;
            }
        }
        return false;
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityFetish tile = WitcheryTileEntities.FETISH.getAt(blockAccess, pos);
        if (tile != null) {
            return tile.getPowerLevel();
        }
        return super.getWeakPower(blockState, blockAccess, pos, side);
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.getWeakPower(blockState, blockAccess, pos, side) : 0;
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.FETISH.create();
    }
}

