/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockBramble;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0019"}, d2={"Lnet/msrandom/witchery/block/BlockEnderBramble;", "Lnet/msrandom/witchery/block/BlockBramble;", "()V", "harvestBlock", "", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "te", "Lnet/minecraft/tileentity/TileEntity;", "stack", "Lnet/minecraft/item/ItemStack;", "onEntityCollision", "entity", "Lnet/minecraft/entity/Entity;", "randomDisplayTick", "stateIn", "rand", "Ljava/util/Random;", "spreadToIfEmpty", "WitcheryResurrected"})
public final class BlockEnderBramble
extends BlockBramble {
    private final void spreadToIfEmpty(World world, BlockPos pos) {
        if (!world.isRemote) {
            BlockPos y = pos.down();
            while (true) {
                BlockPos blockPos = y;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"y");
                if (blockPos.getY() > pos.getY() + 1) break;
                IBlockState iBlockState = world.getBlockState(y);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(y)");
                Block block = iBlockState.getBlock();
                if (block == Blocks.SNOW || block == Blocks.TALLGRASS || block == Blocks.AIR) {
                    IBlockState iBlockState2 = world.getBlockState(y.down());
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"world.getBlockState(y.down())");
                    Block belowBlock = iBlockState2.getBlock();
                    if (belowBlock != Blocks.AIR && world.rand.nextBoolean()) {
                        world.setBlockState(y, this.getDefaultState(), 3);
                        if (world.rand.nextInt(3) != 0) break;
                    }
                }
                y = y.up();
            }
        }
    }

    public void harvestBlock(@NotNull World world, @NotNull EntityPlayer player, @NotNull BlockPos pos, @NotNull IBlockState state, @Nullable TileEntity te, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        super.harvestBlock(world, player, pos, state, te, stack);
        if (!world.isRemote && (stack.isEmpty() || stack.getItem() != Items.GOLDEN_AXE)) {
            BlockPos blockPos = pos.east();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.east()");
            this.spreadToIfEmpty(world, blockPos);
            BlockPos blockPos2 = pos.south();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"pos.south()");
            this.spreadToIfEmpty(world, blockPos2);
            BlockPos blockPos3 = pos.west();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"pos.west()");
            this.spreadToIfEmpty(world, blockPos3);
            BlockPos blockPos4 = pos.north();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"pos.north()");
            this.spreadToIfEmpty(world, blockPos4);
            BlockPos blockPos5 = pos.add(1, 0, 1);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos5, (String)"pos.add(1, 0, 1)");
            this.spreadToIfEmpty(world, blockPos5);
            BlockPos blockPos6 = pos.add(-1, 0, -1);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos6, (String)"pos.add(-1, 0, -1)");
            this.spreadToIfEmpty(world, blockPos6);
            BlockPos blockPos7 = pos.add(-1, 0, 1);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos7, (String)"pos.add(-1, 0, 1)");
            this.spreadToIfEmpty(world, blockPos7);
            BlockPos blockPos8 = pos.add(1, 0, -1);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos8, (String)"pos.add(1, 0, -1)");
            this.spreadToIfEmpty(world, blockPos8);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(@Nullable IBlockState stateIn, @NotNull World world, @NotNull BlockPos pos, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        if (rand.nextBoolean()) {
            double d0 = (double)pos.getX() + (double)rand.nextFloat();
            double d2 = (double)((float)pos.getY() + 0.15f + rand.nextFloat() * 0.3f) + 0.5;
            double d3 = (double)pos.getZ() + (double)rand.nextFloat();
            world.spawnParticle(EnumParticleTypes.PORTAL, d0, d2, d3, 0.0, -1.2, 0.0, new int[0]);
        }
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (!world.isRemote && entity instanceof EntityLivingBase) {
            BlockPos p;
            int distance = 500;
            int doubleDistance = 1000;
            BlockPos blockPos = p = pos.add(world.rand.nextInt(doubleDistance) - distance, 0, world.rand.nextInt(doubleDistance) - distance);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"p");
            int maxY = RangesKt.coerceAtMost((int)(blockPos.getY() + 64), (int)250);
            while (true) {
                IBlockState iBlockState = world.getBlockState(p);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(p)");
                Material material = iBlockState.getMaterial();
                Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"world.getBlockState(p).material");
                if (material.isSolid()) break;
                BlockPos blockPos2 = p;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"p");
                if (blockPos2.getY() < 0) break;
                p = p.down();
            }
            while (true) {
                IBlockState iBlockState = world.getBlockState(p);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(p)");
                Material material = iBlockState.getMaterial();
                Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"world.getBlockState(p).material");
                if (material.isSolid()) {
                    IBlockState iBlockState2 = world.getBlockState(p);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"world.getBlockState(p)");
                    if (iBlockState2.getBlock() != Blocks.BEDROCK && world.isAirBlock(p.up()) && world.isAirBlock(p.up(2)) && world.isAirBlock(p.up(3))) break;
                }
                BlockPos blockPos3 = p;
                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"p");
                if (blockPos3.getY() >= maxY) break;
                p = p.up();
            }
            BlockPos blockPos4 = p;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos4, (String)"p");
            int n = blockPos4.getY();
            if (1 <= n && maxY > n) {
                WorldProvider worldProvider = world.provider;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
                WitcheryIngredientItem.teleportToLocation(p, worldProvider.getDimension(), entity, true);
            }
        }
    }
}

