/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class BlockEmberMoss
extends BlockBush
implements IShearable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.4f, (double)0.9f);

    public BlockEmberMoss() {
        super(Material.PLANTS);
        this.setTickRandomly(true);
        this.setHardness(0.0f);
        this.setLightLevel(0.4f);
        this.setSoundType(SoundType.PLANT);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(world.isRemote || !(entity instanceof EntityLivingBase) || entity.isBurning() || entity.isImmuneToFire() || entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.isCreativeMode)) {
            entity.setFire(3);
            world.playSound(null, 0.5 + (double)pos.getX(), 0.05 + (double)pos.getX(), 0.5 + (double)pos.getZ(), SoundEvents.ENTITY_GHAST_SHOOT, entity.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.getX(), 0.05 + (double)pos.getX(), 0.5 + (double)pos.getZ(), 0.5f, 1.0f, EnumParticleTypes.FLAME), world, pos);
        }
    }

    public void updateTick(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!par1World.isRemote && par1World.rand.nextInt(6) == 0) {
            int b0 = 4;
            int l = 5;
            for (int i1 = pos.getX() - b0; i1 <= pos.getX() + b0; ++i1) {
                for (int j1 = pos.getZ() - b0; j1 <= pos.getZ() + b0; ++j1) {
                    for (int k1 = pos.getY() - 1; k1 <= pos.getY() + 1; ++k1) {
                        if (par1World.getBlockState(new BlockPos(i1, k1, j1)).getBlock() != this || --l > 0) continue;
                        return;
                    }
                }
            }
            BlockPos p1 = pos.add(par5Random.nextInt(3) - 1, par5Random.nextInt(2) - par5Random.nextInt(2), par5Random.nextInt(3) - 1);
            for (int l2 = 0; l2 < 4; ++l2) {
                if (par1World.isAirBlock(p1) && this.canBlockSpread(par1World, p1)) {
                    pos = p1;
                }
                p1 = pos.add(par5Random.nextInt(3) - 1, par5Random.nextInt(2) - par5Random.nextInt(2), par5Random.nextInt(3) - 1);
            }
            if (par1World.isAirBlock(p1) && this.canBlockSpread(par1World, p1)) {
                par1World.setBlockState(p1, state, 2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            double d0 = (float)pos.getX() + 0.2f + rand.nextFloat() * 0.8f;
            double d2 = (float)pos.getY() + 0.15f + rand.nextFloat() * 0.3f;
            double d3 = (float)pos.getZ() + 0.2f + rand.nextFloat() * 0.8f;
            world.spawnParticle(EnumParticleTypes.FLAME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean canPlaceBlockAt(World par1World, BlockPos pos) {
        return super.canPlaceBlockAt(par1World, pos) && this.canBlockStay(par1World, pos);
    }

    protected boolean canSustainBush(IBlockState block) {
        return block != null && block.isOpaqueCube();
    }

    public boolean canBlockSpread(World world, BlockPos pos) {
        Block block = world.getBlockState(pos.down()).getBlock();
        return this.canBlockStay(world, pos) && (block == Blocks.DIRT || block == Blocks.GRASS || block == Blocks.MYCELIUM || block == Blocks.SAND || block == Blocks.FARMLAND);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        Material material = world.getBlockState(pos.down()).getMaterial();
        return material.isSolid();
    }

    public Item getItemDropped(IBlockState par1, Random rand, int fortune) {
        return Items.AIR;
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }
}

