/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityDistillery;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryContainers;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockDistillery
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static boolean keepFurnaceInventory;
    private final boolean isActive;

    public BlockDistillery(boolean burning) {
        super(Material.IRON);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.isActive = burning;
        this.setHardness(3.5f);
        this.setSoundType(SoundType.METAL);
        if (burning) {
            this.setLightLevel(0.4f);
        }
    }

    public static void updateDistilleryBlockState(boolean burning, World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        TileEntityDistillery tileentity = WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)world, pos);
        keepFurnaceInventory = true;
        if (burning) {
            world.setBlockState(pos, WitcheryBlocks.DISTILLERY_BURNING.getDefaultState().withProperty((IProperty)FACING, state.getValue((IProperty)FACING)));
        } else {
            world.setBlockState(pos, WitcheryBlocks.DISTILLERY.getDefaultState().withProperty((IProperty)FACING, state.getValue((IProperty)FACING)));
        }
        keepFurnaceInventory = false;
        if (tileentity != null) {
            tileentity.validate();
            world.setTileEntity(pos, (TileEntity)tileentity);
        }
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)WitcheryBlocks.DISTILLERY);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        TileEntityDistillery tile = WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            WitcheryUtils.openContainer(WitcheryContainers.getDistillery(), player, pos, tile.getDisplayName());
        }
        return true;
    }

    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isActive) {
            double d0 = (float)pos.getX() + 0.4f + rand.nextFloat() * 0.2f;
            double d2 = (float)pos.getY() + 1.0f + rand.nextFloat() * 0.3f;
            double d3 = (float)pos.getZ() + 0.4f + rand.nextFloat() * 0.2f;
            worldIn.spawnParticle(EnumParticleTypes.SPELL_INSTANT, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()), 2);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityDistillery tile;
        if (!keepFurnaceInventory && (tile = WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)worldIn, pos)) != null) {
            InventoryHelper.dropInventoryItems((World)worldIn, (BlockPos)pos, (IInventory)tile);
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState state, World world, BlockPos pos) {
        return Container.calcRedstoneFromInventory((IInventory)((IInventory)WitcheryTileEntities.DISTILLERY.getAt((IBlockAccess)world, pos)));
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)WitcheryBlocks.DISTILLERY);
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.DISTILLERY.create();
    }
}

