/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.CreatureUtil;

public class BlockDisease
extends BlockFluidClassic {
    public BlockDisease(Fluid fluid) {
        super(fluid, Material.SNOW);
        this.quantaPerBlock = 1;
        this.setHardness(100.0f);
        this.setLightOpacity(1);
    }

    public int getMaxRenderHeightMeta() {
        return 15;
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        super.updateTick(world, pos, state, rand);
        int chance = WitcheryConfigOptions.diseaseRemovalChance;
        if (chance > 0) {
            if (world.rand.nextInt(chance) == 0) {
                world.setBlockToAir(pos);
            }
            world.scheduleUpdate(pos, (Block)this, this.tickRate);
        }
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityLivingBase livingEntity;
        if (!world.isRemote && entity instanceof EntityLivingBase && !CreatureUtil.isImmuneToDisease(livingEntity = (EntityLivingBase)entity) && !livingEntity.isPotionActive(WitcheryPotionEffects.DISEASED) && world.rand.nextInt(3) == 0) {
            livingEntity.addPotionEffect(new PotionEffect(WitcheryPotionEffects.DISEASED, (1 + world.rand.nextInt(4)) * 1200));
        }
    }
}

