/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockDemonHeart
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, (double)0.8f, 0.75);

    public BlockDemonHeart() {
        super(Material.GROUND);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setLightLevel(0.2f);
        this.setHardness(1.0f);
        this.setSoundType(SoundType.GROUND);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing()), 2);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new Entity();
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        double yMid = (double)pos.getY() + 0.8;
        double mid1 = 0.35 + 0.3 * rand.nextDouble();
        double mid2 = 0.35 + 0.3 * rand.nextDouble();
        if (rand.nextInt(10) == 0) {
            world.spawnParticle(EnumParticleTypes.FLAME, (double)pos.getX() + mid1, yMid, (double)pos.getZ() + mid2, 0.0, 0.0, 0.0, new int[0]);
            world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, (double)pos.getX() + mid1, yMid, (double)pos.getZ() + mid2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static class Entity
    extends TileEntity
    implements ITickable {
        public void update() {
            if (this.world != null && this.world.isRemote) {
                this.playSound();
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void playSound() {
            EntityPlayerSP player = Minecraft.getMinecraft().player;
            if (player.ticksExisted % 25 == 3) {
                this.world.playSound((double)this.pos.getX() + 0.5, (double)this.pos.getY(), (double)this.pos.getZ(), WitcherySounds.BLOCK_DEMONHEART_BEAT, SoundCategory.BLOCKS, 0.8f, 1.0f, false);
            }
        }
    }
}

