/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.init.WitcheryTileEntities;
import org.jetbrains.annotations.Nullable;

public class BlockCursedDoor
extends BlockContainer {
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);

    public BlockCursedDoor(Material p_i45402_1_) {
        super(p_i45402_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)BlockDoor.FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)BlockDoor.OPEN, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)BlockDoor.HINGE, (Comparable)BlockDoor.EnumHingePosition.LEFT).withProperty((IProperty)BlockDoor.POWERED, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)BlockDoor.HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
        this.setHardness(3.0f);
        this.setSoundType(SoundType.WOOD);
    }

    public void replaceButton(World world, BlockPos pos, ModifiersImpact impactModifiers, NBTTagCompound nbtBrew) {
        IBlockState meta = world.getBlockState(pos);
        if (meta.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            pos = pos.down();
        }
        world.setBlockToAir(pos);
        world.setBlockToAir(pos.up());
        ItemDoor.placeDoor((World)world, (BlockPos)pos, (EnumFacing)((EnumFacing)meta.getValue((IProperty)BlockDoor.FACING)), (Block)this, (meta.getValue((IProperty)BlockDoor.HINGE) == BlockDoor.EnumHingePosition.RIGHT ? 1 : 0) != 0);
        TileEntityCursedBlock tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            tile.initialize(impactModifiers, nbtBrew);
        }
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)worldIn.getBlockState(pos).getValue((IProperty)BlockDoor.OPEN);
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.getActualState(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.getValue((IProperty)BlockDoor.FACING);
        boolean flag = (Boolean)state.getValue((IProperty)BlockDoor.OPEN) == false;
        boolean flag1 = state.getValue((IProperty)BlockDoor.HINGE) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public void onBlockClicked(World worldIn, BlockPos pos, EntityPlayer playerIn) {
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos blockpos = state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.down();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : world.getBlockState(blockpos);
        if (iblockstate.getBlock() != this) {
            return false;
        }
        state = iblockstate.cycleProperty((IProperty)BlockDoor.OPEN);
        TileEntityCursedBlock tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, blockpos);
        if (!world.isRemote && tile != null && tile.applyToEntityAndDestroy((Entity)player)) {
            world.setBlockState(blockpos, state, 10);
        }
        world.markBlockRangeForRenderUpdate(blockpos, pos);
        world.playEvent(player, (Boolean)state.getValue((IProperty)BlockDoor.OPEN) != false ? 1006 : 1012, pos, 0);
        return true;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos = pos.down();
            IBlockState iblockstate = worldIn.getBlockState(blockpos);
            if (iblockstate.getBlock() != this) {
                worldIn.setBlockToAir(pos);
            } else if (blockIn != this) {
                iblockstate.neighborChanged(worldIn, blockpos, blockIn, fromPos);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos1 = pos.up();
            IBlockState iblockstate1 = worldIn.getBlockState(blockpos1);
            if (iblockstate1.getBlock() != this) {
                worldIn.setBlockToAir(pos);
                flag1 = true;
            }
            if (!worldIn.getBlockState(pos.down()).isSideSolid((IBlockAccess)worldIn, pos.down(), EnumFacing.UP)) {
                worldIn.setBlockToAir(pos);
                flag1 = true;
                if (iblockstate1.getBlock() == this) {
                    worldIn.setBlockToAir(blockpos1);
                }
            }
            if (flag1) {
                if (!worldIn.isRemote) {
                    this.dropBlockAsItem(worldIn, pos, state, 0);
                }
            } else {
                boolean flag;
                boolean bl = flag = worldIn.isBlockPowered(pos) || worldIn.isBlockPowered(blockpos1);
                if (blockIn != this && (flag || blockIn.getDefaultState().canProvidePower()) && flag != (Boolean)iblockstate1.getValue((IProperty)BlockDoor.POWERED)) {
                    worldIn.setBlockState(blockpos1, iblockstate1.withProperty((IProperty)BlockDoor.POWERED, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.getValue((IProperty)BlockDoor.OPEN)) {
                        worldIn.setBlockState(pos, state.withProperty((IProperty)BlockDoor.OPEN, (Comparable)Boolean.valueOf(flag)), 2);
                        worldIn.markBlockRangeForRenderUpdate(pos, pos);
                        worldIn.playEvent(null, flag ? 1006 : 1012, pos, 0);
                    }
                }
            }
        }
    }

    public Item getItemDropped(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return p_149650_1_.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER ? Items.AIR : Items.OAK_DOOR;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Items.OAK_DOOR);
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        if (pos.getY() >= worldIn.getHeight() - 1) {
            return false;
        }
        IBlockState state = worldIn.getBlockState(pos.down());
        return (state.isTopSolid() || state.getBlockFaceShape((IBlockAccess)worldIn, pos.down(), EnumFacing.UP) == BlockFaceShape.SOLID) && super.canPlaceBlockAt(worldIn, pos) && super.canPlaceBlockAt(worldIn, pos.up());
    }

    public EnumPushReaction getPushReaction(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.OAK_DOOR);
    }

    public void onBlockHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.down();
        BlockPos blockpos1 = pos.up();
        if (player.capabilities.isCreativeMode && state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER && worldIn.getBlockState(blockpos).getBlock() == this) {
            worldIn.setBlockToAir(blockpos);
        }
        if (state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER && worldIn.getBlockState(blockpos1).getBlock() == this) {
            if (player.capabilities.isCreativeMode) {
                worldIn.setBlockToAir(pos);
            }
            worldIn.setBlockToAir(blockpos1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER) {
            IBlockState iblockstate = worldIn.getBlockState(pos.up());
            if (iblockstate.getBlock() == this) {
                state = state.withProperty((IProperty)BlockDoor.HINGE, iblockstate.getValue((IProperty)BlockDoor.HINGE)).withProperty((IProperty)BlockDoor.POWERED, iblockstate.getValue((IProperty)BlockDoor.POWERED));
            }
        } else {
            IBlockState iblockstate1 = worldIn.getBlockState(pos.down());
            if (iblockstate1.getBlock() == this) {
                state = state.withProperty((IProperty)BlockDoor.FACING, iblockstate1.getValue((IProperty)BlockDoor.FACING)).withProperty((IProperty)BlockDoor.OPEN, iblockstate1.getValue((IProperty)BlockDoor.OPEN));
            }
        }
        return state;
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.getValue((IProperty)BlockDoor.HALF) != BlockDoor.EnumDoorHalf.LOWER ? state : state.withProperty((IProperty)BlockDoor.FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)BlockDoor.FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)BlockDoor.FACING))).cycleProperty((IProperty)BlockDoor.HINGE);
    }

    public IBlockState getStateFromMeta(int meta) {
        return (meta & 8) > 0 ? this.getDefaultState().withProperty((IProperty)BlockDoor.HALF, (Comparable)BlockDoor.EnumDoorHalf.UPPER).withProperty((IProperty)BlockDoor.HINGE, (Comparable)((meta & 1) > 0 ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT)).withProperty((IProperty)BlockDoor.POWERED, (Comparable)Boolean.valueOf((meta & 2) > 0)) : this.getDefaultState().withProperty((IProperty)BlockDoor.HALF, (Comparable)BlockDoor.EnumDoorHalf.LOWER).withProperty((IProperty)BlockDoor.FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)).rotateYCCW()).withProperty((IProperty)BlockDoor.OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        if (state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER) {
            i |= 8;
            if (state.getValue((IProperty)BlockDoor.HINGE) == BlockDoor.EnumHingePosition.RIGHT) {
                i |= 1;
            }
            if (((Boolean)state.getValue((IProperty)BlockDoor.POWERED)).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= ((EnumFacing)state.getValue((IProperty)BlockDoor.FACING)).rotateY().getHorizontalIndex();
            if (((Boolean)state.getValue((IProperty)BlockDoor.OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{BlockDoor.HALF, BlockDoor.FACING, BlockDoor.OPEN, BlockDoor.HINGE, BlockDoor.POWERED}).build();
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.CURSED_BLOCK.create();
    }
}

