/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCrystalBall;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.prediction.Prediction;
import org.jetbrains.annotations.Nullable;

public class BlockCrystalBall
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);
    private static final float ALTAR_POWER_PER_READING = 500.0f;

    public BlockCrystalBall() {
        super(Material.ANVIL);
        this.setHardness(2.0f);
        this.setSoundType(SoundType.METAL);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static boolean tryConsumePower(World world, EntityPlayer player, BlockPos pos) {
        IPowerSource powerSource = BlockCrystalBall.findNewPowerSource(world, pos);
        if (powerSource != null && powerSource.consumePower(500.0f)) {
            return true;
        }
        if (!world.isRemote) {
            player.sendMessage(new TextComponentTranslation("prediction.witchery.no_altar_power", new Object[0]).setStyle(new Style().setColor(TextFormatting.GRAY)));
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        }
        return false;
    }

    private static IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            TileEntityCrystalBall ball = WitcheryTileEntities.CRYSTAL_BALL.getAt((IBlockAccess)world, pos);
            if (ball != null) {
                if (ball.canBeUsed()) {
                    int x = pos.getX();
                    int y = pos.getY();
                    int z = pos.getZ();
                    if (BlockCrystalBall.tryConsumePower(world, player, pos)) {
                        AxisAlignedBB bounds = new AxisAlignedBB(0.5 + (double)x - 5.0, 0.5 + (double)y - 2.0, 0.5 + (double)z - 5.0, 0.5 + (double)x + 5.0, 0.5 + (double)y + 2.0, 0.5 + (double)z + 5.0);
                        List players = world.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                        EntityPlayer victim = player;
                        double closest = 10000.0;
                        for (EntityPlayer nearbyPlayer : players) {
                            double distSq;
                            if (nearbyPlayer == null || nearbyPlayer == player || !((distSq = player.getDistanceSq(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z)) < closest)) continue;
                            victim = nearbyPlayer;
                            closest = distSq;
                        }
                        Prediction.makePrediction(victim, player, true);
                        ball.onUsed();
                        world.playSound(null, 0.5 + (double)x, 0.2 + (double)y, 0.5 + (double)z, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, 0.2 + (double)y, 0.5 + (double)z, 0.2f, 0.2f, EnumParticleTypes.EXPLOSION_NORMAL), world, 0.5 + (double)x, 0.2 + (double)y, 0.5 + (double)z);
                    }
                } else {
                    player.sendMessage(new TextComponentTranslation("prediction.witchery.recharging", new Object[0]).setStyle(new Style().setColor(TextFormatting.GRAY)));
                    world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
            }
            return true;
        }
        return true;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canPlaceBlockAt(world, pos)) {
            this.dropBlockAsItem(world, pos, state, 0);
            world.setBlockToAir(pos);
        }
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        Material material = world.getBlockState(pos.down()).getMaterial();
        return !world.isAirBlock(pos.down()) && material.isOpaque() && material.isSolid();
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.CRYSTAL_BALL.create();
    }
}

