/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.resources.CritterSnareManager;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016JP\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J(\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0017J(\u0010'\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010(\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006+"}, d2={"Lnet/msrandom/witchery/block/BlockCritterSnare;", "Lnet/minecraft/block/BlockBush;", "()V", "data", "Lnet/msrandom/witchery/block/BlockCritterSnare$Data;", "getData", "()Lnet/msrandom/witchery/block/BlockCritterSnare$Data;", "canPlaceBlockAt", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "canSustainBush", "block", "Lnet/minecraft/block/state/IBlockState;", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "state", "source", "Lnet/minecraft/world/IBlockAccess;", "onBlockActivated", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onEntityCollision", "", "entity", "Lnet/minecraft/entity/Entity;", "randomDisplayTick", "rand", "Ljava/util/Random;", "trapEntity", "position", "Companion", "Data", "WitcheryResurrected"})
public final class BlockCritterSnare
extends BlockBush {
    private static final AxisAlignedBB AABB;
    public static final Companion Companion;

    private final Data getData() {
        return CritterSnareManager.INSTANCE.getData(this);
    }

    @NotNull
    public AxisAlignedBB getBoundingBox(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return AABB;
    }

    public void onEntityCollision(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entity) {
        Data data;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        if (this.getData() == null && !world.isRemote && entity.isEntityAlive() && entity instanceof EntityLiving && ((EntityLiving)entity).isNonBoss() && (data = CritterSnareManager.INSTANCE.getData(((EntityLiving)entity).getClass())) != null) {
            this.trapEntity(world, pos, data, entity);
        }
    }

    private final void trapEntity(World world, BlockPos position, Data data, Entity entity) {
        NBTPredicate nBTPredicate = data.getCondition$WitcheryResurrected();
        if (nBTPredicate == null || nBTPredicate.test(entity)) {
            world.setBlockState(position, data.getBlock$WitcheryResurrected().getDefaultState(), 3);
            entity.setDead();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onBlockActivated(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
            Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
            Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
            data = this.getData();
            if (world.isRemote || data == null || !player.isSneaking()) break block6;
            type = CritterSnareManager.INSTANCE.getType(this);
            v0 = type;
            if (v0 == null) ** GOTO lbl-1000
            var13_12 = v0;
            var14_13 = false;
            var15_14 = false;
            it = var13_12;
            $i$a$-let-BlockCritterSnare$onBlockActivated$entity$1 = false;
            v0 = EntityRegistry.getEntry(it);
            if (v0 != null) {
                v1 = v0.newInstance(world);
            } else lbl-1000:
            // 2 sources

            {
                v1 = entity = null;
            }
            if (entity != null) {
                world.setBlockState(pos, WitcheryBlocks.EMPTY_CRITTER_SNARE.getDefaultState(), 3);
                if (data.getFly$WitcheryResurrected()) {
                    entity.setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                } else {
                    entity.setLocationAndAngles(player.posX < (double)pos.getX() ? (double)pos.getX() - 0.5 : (double)pos.getX() + 1.5, player.posY + 0.5, player.posZ < (double)pos.getZ() ? (double)pos.getZ() - 0.5 : (double)pos.getZ() + 1.5, 0.0f, 0.0f);
                }
                world.spawnEntity(entity);
                if (Intrinsics.areEqual((Object)data.getDrop$WitcheryResurrected(), (Object)Items.AIR) ^ true) {
                    world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, new ItemStack(data.getDrop$WitcheryResurrected())));
                }
                return true;
            }
        }
        return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Random rand) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
            Data data = this.getData();
            if (data == null) break block1;
            Data data2 = data;
            boolean bl = false;
            boolean bl2 = false;
            Data it = data2;
            boolean bl3 = false;
            if (it.getSound$WitcheryResurrected() != null && rand.nextInt(24) == 0) {
                EntityPlayerSP entityPlayerSP = Minecraft.getMinecraft().player;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerSP, (String)"Minecraft.getMinecraft().player");
                WitcheryUtils.playSoundAt((EntityPlayer)entityPlayerSP, it.getSound$WitcheryResurrected(), SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlaceBlockAt(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (!super.canPlaceBlockAt(world, pos)) return false;
        IBlockState iBlockState = world.getBlockState(pos.down());
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos.down())");
        Material material = iBlockState.getMaterial();
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"world.getBlockState(pos.down()).material");
        if (!material.isSolid()) return false;
        return true;
    }

    protected boolean canSustainBush(@NotNull IBlockState block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        return block.isOpaqueCube();
    }

    public BlockCritterSnare() {
        this.setSoundType(SoundType.PLANT);
        this.setCreativeTab(null);
    }

    static {
        Companion = new Companion(null);
        AABB = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 1.0, 0.95);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lnet/msrandom/witchery/block/BlockCritterSnare$Data;", "", "block", "Lnet/msrandom/witchery/block/BlockCritterSnare;", "condition", "Lnet/minecraft/advancements/critereon/NBTPredicate;", "sound", "Lnet/minecraft/util/SoundEvent;", "drop", "Lnet/minecraft/item/Item;", "fly", "", "(Lnet/msrandom/witchery/block/BlockCritterSnare;Lnet/minecraft/advancements/critereon/NBTPredicate;Lnet/minecraft/util/SoundEvent;Lnet/minecraft/item/Item;Z)V", "getBlock$WitcheryResurrected", "()Lnet/msrandom/witchery/block/BlockCritterSnare;", "getCondition$WitcheryResurrected", "()Lnet/minecraft/advancements/critereon/NBTPredicate;", "getDrop$WitcheryResurrected", "()Lnet/minecraft/item/Item;", "getFly$WitcheryResurrected", "()Z", "getSound$WitcheryResurrected", "()Lnet/minecraft/util/SoundEvent;", "WitcheryResurrected"})
    public static final class Data {
        @NotNull
        private final BlockCritterSnare block;
        @Nullable
        private final NBTPredicate condition;
        @Nullable
        private final SoundEvent sound;
        @NotNull
        private final Item drop;
        private final boolean fly;

        @NotNull
        public final BlockCritterSnare getBlock$WitcheryResurrected() {
            return this.block;
        }

        @Nullable
        public final NBTPredicate getCondition$WitcheryResurrected() {
            return this.condition;
        }

        @Nullable
        public final SoundEvent getSound$WitcheryResurrected() {
            return this.sound;
        }

        @NotNull
        public final Item getDrop$WitcheryResurrected() {
            return this.drop;
        }

        public final boolean getFly$WitcheryResurrected() {
            return this.fly;
        }

        public Data(@NotNull BlockCritterSnare block, @Nullable NBTPredicate condition, @Nullable SoundEvent sound, @NotNull Item drop, boolean fly) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)block), (String)"block");
            Intrinsics.checkParameterIsNotNull((Object)drop, (String)"drop");
            this.block = block;
            this.condition = condition;
            this.sound = sound;
            this.drop = drop;
            this.fly = fly;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/msrandom/witchery/block/BlockCritterSnare$Companion;", "", "()V", "AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

