/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockCotton
extends BlockBush {
    public BlockCotton() {
        super(Material.PLANTS);
        this.setHardness(0.0f);
        this.setSoundType(SoundType.PLANT);
        this.setTickRandomly(true);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public boolean canBlockSpread(World world, BlockPos pos) {
        if (WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world) && this.canBlockStay(world, pos, world.getBlockState(pos))) {
            Block blockBelow = world.getBlockState(pos.down()).getBlock();
            return blockBelow == Blocks.DIRT || blockBelow == Blocks.GRASS;
        }
        return false;
    }

    private boolean isBlockMatch(World world, BlockPos pos, Block block) {
        return world.getBlockState(pos).getBlock() != block;
    }

    public void updateTick(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!par1World.isRemote && par1World.rand.nextInt(6) == 0) {
            if (!WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(par1World) || this.isBlockMatch(par1World, pos.add(1, -1, 0), (Block)WitcheryBlocks.FLOWING_SPIRIT) && this.isBlockMatch(par1World, pos.add(-1, -1, 0), (Block)WitcheryBlocks.FLOWING_SPIRIT) && this.isBlockMatch(par1World, pos.add(0, -1, 1), (Block)WitcheryBlocks.FLOWING_SPIRIT) && this.isBlockMatch(par1World, pos.add(0, -1, -1), (Block)WitcheryBlocks.FLOWING_SPIRIT)) {
                return;
            }
            int b0 = 4;
            int l = 5;
            for (int i1 = pos.getX() - b0; i1 <= pos.getX() + b0; ++i1) {
                for (int j1 = pos.getZ() - b0; j1 <= pos.getZ() + b0; ++j1) {
                    for (int k1 = pos.getY() - 1; k1 <= pos.getY() + 1; ++k1) {
                        if (par1World.getBlockState(new BlockPos(i1, k1, j1)).getBlock() != this || --l > 0) continue;
                        return;
                    }
                }
            }
            BlockPos p1 = pos.add(par5Random.nextInt(3) - 1, par5Random.nextInt(2) - par5Random.nextInt(2), par5Random.nextInt(3) - 1);
            for (int l2 = 0; l2 < 4; ++l2) {
                if (par1World.isAirBlock(p1) && this.canBlockSpread(par1World, p1)) {
                    pos = p1;
                }
                p1 = pos.add(par5Random.nextInt(3) - 1, par5Random.nextInt(2) - par5Random.nextInt(2), par5Random.nextInt(3) - 1);
            }
            if (par1World.isAirBlock(p1) && this.canBlockSpread(par1World, p1)) {
                par1World.setBlockState(p1, this.getDefaultState(), 2);
            }
        }
    }
}

