/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.msrandom.witchery.block.BlockCoffin$WhenMappings;
import net.msrandom.witchery.block.entity.TileEntityCoffin;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 72\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J \u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016JP\u0010#\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0016H\u0016J(\u0010,\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0016H\u0016J\u0018\u0010/\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u00020\"H\u0016J(\u00101\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020$2\u0006\u00102\u001a\u00020 H\u0016J(\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00106\u001a\u00020(H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00068"}, d2={"Lnet/msrandom/witchery/block/BlockCoffin;", "Lnet/minecraft/block/BlockBed;", "color", "Lnet/minecraft/item/EnumDyeColor;", "(Lnet/minecraft/item/EnumDyeColor;)V", "getColor", "()Lnet/minecraft/item/EnumDyeColor;", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "createNewTileEntity", "Lnet/msrandom/witchery/block/entity/TileEntityCoffin;", "worldIn", "Lnet/minecraft/world/World;", "meta", "", "dropBlockAsItemWithChance", "", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "chance", "", "fortune", "getActualState", "world", "Lnet/minecraft/world/IBlockAccess;", "getItem", "Lnet/minecraft/item/ItemStack;", "getMetaFromState", "getStateFromMeta", "isBed", "", "player", "Lnet/minecraft/entity/Entity;", "onBlockActivated", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "hitY", "hitZ", "onFallenUpon", "entity", "fallDistance", "onLanded", "entityIn", "setBedOccupied", "occupied", "shouldSideBeRendered", "blockState", "blockAccess", "side", "Companion", "WitcheryResurrected"})
public final class BlockCoffin
extends BlockBed {
    @NotNull
    private final EnumDyeColor color;
    @JvmField
    @NotNull
    public static final PropertyBool OPEN;
    public static final Companion Companion;

    public boolean isBed(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable Entity player) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onBlockActivated(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos headPos;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        BlockPos footPos = headPos = pos;
        if (world.isRemote) {
            return true;
        }
        if ((BlockBed.EnumPartType)state.getValue((IProperty)BlockBed.PART) == BlockBed.EnumPartType.FOOT) {
            BlockPos blockPos = headPos.offset((EnumFacing)state.getValue((IProperty)BlockBed.FACING));
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"headPos.offset(state.getValue(FACING))");
            headPos = blockPos;
            IBlockState iBlockState = world.getBlockState(footPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(footPos)");
            if (iBlockState.getBlock() != this) {
                return true;
            }
        } else {
            Comparable comparable = state.getValue((IProperty)BlockBed.FACING);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.getValue(FACING)");
            BlockPos blockPos = footPos.offset(((EnumFacing)comparable).getOpposite());
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"footPos.offset(state.getValue(FACING).opposite)");
            footPos = blockPos;
        }
        IBlockState headState = world.getBlockState(headPos);
        IBlockState footState = world.getBlockState(footPos);
        if (player.isSneaking()) {
            Comparable comparable = footState.getValue((IProperty)OPEN);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"footState.getValue(OPEN)");
            if (((Boolean)comparable).booleanValue()) {
                Comparable comparable2 = headState.getValue((IProperty)BlockBed.OCCUPIED);
                Intrinsics.checkExpressionValueIsNotNull((Object)comparable2, (String)"headState.getValue(OCCUPIED)");
                if (((Boolean)comparable2).booleanValue()) {
                    EntityPlayer sleepingPlayer = null;
                    Iterator iterator = world.playerEntities.iterator();
                    while (iterator.hasNext()) {
                        BlockPos bedLocation;
                        EntityPlayer worldPlayer;
                        EntityPlayer entityPlayer = worldPlayer = (EntityPlayer)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"worldPlayer");
                        if (!entityPlayer.isPlayerSleeping() || Intrinsics.areEqual((Object)(bedLocation = worldPlayer.bedLocation), (Object)headPos) ^ true) continue;
                        sleepingPlayer = worldPlayer;
                    }
                    if (sleepingPlayer != null) {
                        return true;
                    }
                }
            }
            if (world.isSideSolid(headPos.up(), EnumFacing.DOWN)) return true;
            if (world.isSideSolid(new BlockPos(footPos.getX(), headPos.getY() + 1, footPos.getZ()), EnumFacing.DOWN)) {
                return true;
            }
            world.setBlockState(footPos, footState.withProperty((IProperty)OPEN, (Comparable)Boolean.valueOf((Boolean)footState.getValue((IProperty)OPEN) == false)));
            return true;
        }
        if (!((Boolean)footState.getValue((IProperty)OPEN)).booleanValue()) {
            player.sendStatusMessage((ITextComponent)new TextComponentTranslation("tile.witchery.coffin.closed", new Object[0]), true);
            return true;
        }
        WorldProvider.WorldSleepResult sleepResult = world.provider.canSleepAt(player, headPos);
        if (sleepResult == WorldProvider.WorldSleepResult.BED_EXPLODES) {
            world.setBlockToAir(headPos);
            EnumFacing k1 = (EnumFacing)footState.getValue((IProperty)BlockBed.FACING);
            BlockPos blockPos = headPos.offset(k1);
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"headPos.offset(k1)");
            headPos = blockPos;
            IBlockState iBlockState = world.getBlockState(headPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(headPos)");
            if (iBlockState.getBlock() == this) {
                world.setBlockToAir(headPos);
            }
        } else {
            if (sleepResult == WorldProvider.WorldSleepResult.DENY) {
                return true;
            }
            Comparable comparable = footState.getValue((IProperty)BlockBed.OCCUPIED);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"footState.getValue(OCCUPIED)");
            if (((Boolean)comparable).booleanValue()) {
                EntityPlayer sleepingPlayer = null;
                Iterator iterator = world.playerEntities.iterator();
                while (iterator.hasNext()) {
                    BlockPos bedLocation;
                    EntityPlayer worldPlayer;
                    EntityPlayer entityPlayer = worldPlayer = (EntityPlayer)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayer, (String)"worldPlayer");
                    if (!entityPlayer.isPlayerSleeping() || Intrinsics.areEqual((Object)(bedLocation = worldPlayer.bedLocation), (Object)headPos) ^ true) continue;
                    sleepingPlayer = worldPlayer;
                }
                if (sleepingPlayer != null) {
                    player.sendStatusMessage((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                    return true;
                }
                this.setBedOccupied((IBlockAccess)world, headPos, player, false);
            }
            EntityPlayer.SleepResult sleepResult2 = player.trySleep(headPos);
            if (sleepResult2 == null) return true;
            switch (BlockCoffin$WhenMappings.$EnumSwitchMapping$0[sleepResult2.ordinal()]) {
                case 1: {
                    this.setBedOccupied((IBlockAccess)world, headPos, player, true);
                    return true;
                }
                case 2: {
                    player.sendStatusMessage((ITextComponent)new TextComponentTranslation(WitcheryUtils.getExtension(player).isTransformation(WitcheryTransformations.VAMPIRE) ? "tile.witchery.coffin.night_time" : "tile.bed.noSleep", new Object[0]), true);
                    return true;
                }
                case 3: {
                    player.sendStatusMessage((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
                    return true;
                }
                case 4: {
                    player.sendStatusMessage((ITextComponent)new TextComponentTranslation("tile.witchery.coffin.tooFarAway", new Object[0]), true);
                    return true;
                }
                default: {
                    return true;
                }
            }
        }
        world.newExplosion(null, (double)headPos.getX() + 0.5, (double)headPos.getY() + 0.5, (double)headPos.getZ() + 0.5, 5.0f, true, true);
        return true;
    }

    public void setBedOccupied(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityPlayer player, boolean occupied) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (world instanceof World) {
            TileEntity entity = world.getTileEntity(pos);
            super.setBedOccupied(world, pos, player, occupied);
            ((World)world).setTileEntity(pos, entity);
        }
    }

    public void onFallenUpon(@NotNull World world, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Comparable comparable = world.getBlockState(pos).getValue((IProperty)OPEN);
        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"world.getBlockState(pos).getValue(OPEN)");
        super.onFallenUpon(world, pos, entity, (Boolean)comparable != false ? fallDistance : fallDistance * (float)2);
    }

    public void onLanded(@NotNull World worldIn, @NotNull Entity entityIn) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        entityIn.motionY = 0.0;
    }

    public void dropBlockAsItemWithChance(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, float chance, int fortune) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (!worldIn.isRemote && !worldIn.restoringBlockSnapshots) {
            NonNullList drops = NonNullList.create();
            this.getDrops(drops, (IBlockAccess)worldIn, pos, state, fortune);
            float dropChance = ForgeEventFactory.fireBlockHarvesting((List)((List)drops), (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.rand.nextFloat() <= dropChance)) continue;
                BlockBed.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    @NotNull
    public ItemStack getItem(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return new ItemStack((Block)this);
    }

    @Nullable
    public TileEntityCoffin createNewTileEntity(@NotNull World worldIn, int meta) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        return WitcheryTileEntities.COFFIN.create();
    }

    @NotNull
    public IBlockState getActualState(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockState actualState = super.getActualState(state, world, pos);
        if ((BlockBed.EnumPartType)state.getValue((IProperty)BlockBed.PART) == BlockBed.EnumPartType.HEAD) {
            IBlockState footState;
            Comparable comparable = state.getValue((IProperty)BlockBed.FACING);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.getValue(FACING)");
            IBlockState iBlockState = footState = world.getBlockState(pos.offset(((EnumFacing)comparable).getOpposite()));
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"footState");
            if (iBlockState.getBlock() == this) {
                actualState = state.withProperty((IProperty)OPEN, footState.getValue((IProperty)OPEN));
            }
        }
        IBlockState iBlockState = actualState;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"actualState");
        return iBlockState;
    }

    @NotNull
    protected BlockStateContainer createBlockState() {
        BlockStateContainer blockStateContainer = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{(IProperty)BlockBed.FACING, (IProperty)BlockBed.PART, (IProperty)BlockBed.OCCUPIED, (IProperty)OPEN}).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockStateContainer, (String)"BlockStateContainer.Buil\u2026, OCCUPIED, OPEN).build()");
        return blockStateContainer;
    }

    @NotNull
    public IBlockState getStateFromMeta(int meta) {
        IBlockState iBlockState;
        IBlockState state = super.getStateFromMeta(meta);
        if ((BlockBed.EnumPartType)state.getValue((IProperty)BlockBed.PART) == BlockBed.EnumPartType.FOOT) {
            IBlockState iBlockState2 = state.withProperty((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) != 0));
            iBlockState = iBlockState2;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"state.withProperty(OPEN, meta and 4 != 0)");
        } else {
            IBlockState iBlockState3 = state;
            iBlockState = iBlockState3;
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState3, (String)"state");
        }
        return iBlockState;
    }

    public int getMetaFromState(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        int i = super.getMetaFromState(state);
        if ((BlockBed.EnumPartType)state.getValue((IProperty)BlockBed.PART) == BlockBed.EnumPartType.FOOT) {
            Comparable comparable = state.getValue((IProperty)OPEN);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"state.getValue(OPEN)");
            if (((Boolean)comparable).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public boolean shouldSideBeRendered(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
        Intrinsics.checkParameterIsNotNull((Object)blockAccess, (String)"blockAccess");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        return true;
    }

    @NotNull
    public final EnumDyeColor getColor() {
        return this.color;
    }

    public BlockCoffin(@NotNull EnumDyeColor color2) {
        Intrinsics.checkParameterIsNotNull((Object)color2, (String)"color");
        this.color = color2;
        BlockStateContainer blockStateContainer = this.blockState;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockStateContainer, (String)"blockState");
        this.setDefaultState(blockStateContainer.getBaseState().withProperty((IProperty)BlockBed.FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)BlockBed.PART, (Comparable)BlockBed.EnumPartType.FOOT).withProperty((IProperty)BlockBed.OCCUPIED, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
        this.setHardness(1.0f);
        this.disableStats();
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    static {
        Companion = new Companion(null);
        PropertyBool propertyBool = PropertyBool.create((String)"open");
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyBool, (String)"PropertyBool.create(\"open\")");
        OPEN = propertyBool;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/msrandom/witchery/block/BlockCoffin$Companion;", "", "()V", "OPEN", "Lnet/minecraft/block/properties/PropertyBool;", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

