/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class BlockCircleGlyph
extends Block {
    public static final PropertyBool ACTIVE = PropertyBool.create((String)"active");
    public static final PropertyEnum<Type> GLYPH = PropertyEnum.create((String)"glyph", Type.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.015625, 1.0);
    private final TextFormatting textFormatting;
    private final EnumParticleTypes particles;

    public BlockCircleGlyph() {
        this(null, null);
    }

    public BlockCircleGlyph(TextFormatting textFormatting, EnumParticleTypes particles) {
        super(Material.VINE);
        this.textFormatting = textFormatting;
        this.particles = particles;
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).withProperty(GLYPH, (Comparable)((Object)Type.KA)));
        this.setResistance(1000.0f);
        this.setHardness(2.0f);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemstack;
        if (!(world.isRemote || (itemstack = player.getHeldItemMainhand()).isEmpty() || itemstack.getItem() != WitcheryIngredientItems.BROOM && itemstack.getItem() != WitcheryIngredientItems.ENCHANTED_BROOM)) {
            world.destroyBlock(pos, false);
        }
    }

    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (this.particles != null && !((Boolean)stateIn.getValue((IProperty)ACTIVE)).booleanValue()) {
            double d0 = (float)x + 0.4f + rand.nextFloat() * 0.2f;
            double d2 = (float)y + 0.1f + rand.nextFloat() * 0.3f;
            double d3 = (float)z + 0.4f + rand.nextFloat() * 0.2f;
            world.spawnParticle(this.particles, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canPlaceBlockAt(world, pos)) {
            world.setBlockToAir(pos);
        }
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        Material material = world.getBlockState(pos).getMaterial();
        Material materialBelow = world.getBlockState(pos.down()).getMaterial();
        return materialBelow.isOpaque() && materialBelow.isSolid() && !material.isOpaque() && !material.isSolid();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(GLYPH, (Comparable)((Object)Type.VALUES[meta]));
    }

    public int getMetaFromState(IBlockState state) {
        return ((Type)((Object)state.getValue(GLYPH))).ordinal();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{ACTIVE, GLYPH}).build();
    }

    public TextFormatting getTextFormatting() {
        return this.textFormatting;
    }

    public static enum Type implements IStringSerializable
    {
        KA,
        GO,
        SA,
        ZA,
        TA,
        DO,
        NI,
        HI,
        BO,
        PO,
        MA,
        RI;

        private static final Type[] VALUES;

        public static Type getForPlacement(Random random) {
            return VALUES[random.nextInt(VALUES.length)];
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = Type.values();
        }
    }
}

