/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Pair;
import kotlin.TuplesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.block.entity.TileEntityGrassper;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.resources.RiteManager;
import net.msrandom.witchery.rite.Rite;
import net.msrandom.witchery.rite.RitualCircle;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockCircle
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.015625, 1.0);

    public BlockCircle() {
        super(Material.VINE);
        this.setHardness(3.0f);
        this.setResistance(1000.0f);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemstack;
        if (!(world.isRemote || (itemstack = player.getHeldItem(player.getActiveHand())).isEmpty() || itemstack.getItem() != WitcheryIngredientItems.BROOM && itemstack.getItem() != WitcheryIngredientItems.ENCHANTED_BROOM)) {
            world.destroyBlock(pos, false);
        }
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.canPlace(worldIn, pos)) {
            boolean flag = worldIn.isBlockPowered(pos);
            TileEntityCircle tileCircle = WitcheryTileEntities.CIRCLE.getAt((IBlockAccess)worldIn, pos);
            if (tileCircle != null && tileCircle.previousRedstoneState != flag) {
                if (flag) {
                    this.activateBlock(worldIn, pos, null, false);
                }
                tileCircle.previousRedstoneState = flag;
            }
        }
    }

    private boolean canPlace(World par1World, BlockPos pos) {
        if (!this.canPlaceBlockAt(par1World, pos)) {
            par1World.setBlockToAir(pos);
            return false;
        }
        return true;
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        BlockPos down = pos.down();
        IBlockState lower = world.getBlockState(down);
        Material material = lower.getMaterial();
        return !WitcheryUtils.isAir(lower, (IBlockAccess)world, down) && material.isOpaque() && material.isSolid();
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile instanceof TileEntityCircle && ((TileEntityCircle)tile).active) {
            double d0 = (float)pos.getX() + 0.4f + rand.nextFloat() * 0.2f;
            double d2 = (float)pos.getY() + 0.1f + rand.nextFloat() * 0.3f;
            double d3 = (float)pos.getZ() + 0.4f + rand.nextFloat() * 0.2f;
            worldIn.spawnParticle(EnumParticleTypes.REDSTONE, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean summonCoven;
        ItemStack stack = player.getHeldItem(hand);
        boolean bl = summonCoven = stack.getItem() == WitcheryIngredientItems.SEER_STONE;
        if (!stack.isEmpty() && !summonCoven) {
            return false;
        }
        this.activateBlock(world, pos, player, summonCoven);
        return true;
    }

    private void activateBlock(World world, BlockPos pos, EntityPlayer player, boolean summonCoven) {
        TileEntityCircle tileEntity = WitcheryTileEntities.CIRCLE.getAt((IBlockAccess)world, pos);
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.isRitualActive()) {
            tileEntity.deactivate();
            return;
        }
        if (world.isRemote) {
            return;
        }
        if (PowerSources.instance().isAreaNullified(pos) || WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world)) {
            player.sendMessage(new TextComponentTranslation("rite.witchery.area_nullified", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            return;
        }
        boolean ritualFound = false;
        int covenSize = summonCoven ? WitcheryUtils.getExtension((EntityPlayer)player).coven.size() : 0;
        HashSet<ItemStack> grassperStacks = new HashSet<ItemStack>();
        int radius = 5;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ItemStack stack;
                TileEntityGrassper grassper;
                BlockPos p = pos.add(x, 0, z);
                if (world.getBlockState(p).getBlock() != WitcheryBlocks.GRASSPER || (grassper = WitcheryTileEntities.GRASSPER.getAt((IBlockAccess)world, p)) == null || (stack = grassper.getStackInSlot(0)).isEmpty()) continue;
                grassperStacks.add(stack);
            }
        }
        HashSet<Entity> entities = new HashSet<Entity>();
        HashSet<RitualCircle> circlesFound = new HashSet<RitualCircle>();
        AtomicInteger biggestSearchedSize = new AtomicInteger();
        AtomicReference<AxisAlignedBB> bounds = new AtomicReference<AxisAlignedBB>();
        TreeSet<Rite.PotentialAttemptMatch> potentialMatches = new TreeSet<Rite.PotentialAttemptMatch>();
        for (Rite rite : RiteManager.INSTANCE.getRites()) {
            if (!rite.isMatch(world, pos, circlesFound, biggestSearchedSize, bounds, entities, grassperStacks, potentialMatches)) continue;
            tileEntity.queueRitual(rite, null, bounds.get(), circlesFound, player, covenSize, summonCoven);
            summonCoven = false;
            ritualFound = true;
        }
        if (!ritualFound) {
            if (!potentialMatches.isEmpty()) {
                Rite.PotentialAttemptMatch match2 = (Rite.PotentialAttemptMatch)potentialMatches.first();
                tileEntity.queueRitual(match2.getRite(), (Pair<String, Integer>)TuplesKt.to((Object)match2.getFailure(), (Object)match2.getSacrificeIndex()), bounds.get(), circlesFound, player, covenSize, summonCoven);
            } else if (player != null) {
                RiteEffect.error("unknown_rite", player);
                WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.CIRCLE.create();
    }
}

