/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockChalice
extends Block {
    private static final AxisAlignedBB AABB = WitcheryUtils.getBlockShape(5.5, 0.0, 5.5, 10.5, 11.0, 10.5);
    public final boolean isFull;

    public BlockChalice(boolean isFull) {
        super(Material.ANVIL);
        this.isFull = isFull;
        this.setHardness(3.0f);
        this.setSoundType(SoundType.METAL);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canPlaceBlockAt(worldIn, pos)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        Material material = world.getBlockState(pos.down()).getMaterial();
        return !world.isAirBlock(pos.down()) && material.isOpaque() && material.isSolid();
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (this.isFull) {
            double d0 = (float)pos.getX() + 0.5f;
            double d2 = (float)pos.getY() + 0.7f;
            double d3 = (float)pos.getZ() + 0.5f;
            world.spawnParticle(EnumParticleTypes.REDSTONE, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

