/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockCandelabra
extends Block {
    private static final PropertyEnum<EnumFacing> FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, 1.0, (double)0.9f);

    public BlockCandelabra() {
        super(Material.ANVIL);
        this.setLightLevel(1.0f);
        this.setHardness(2.0f);
        this.setSoundType(SoundType.METAL);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty(FACING, (Comparable)EnumFacing.NORTH));
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canPlaceBlockAt(worldIn, pos) && !worldIn.isRemote) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty(FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.setBlockState(pos, state.withProperty(FACING, (Comparable)entity.getHorizontalFacing().getOpposite()));
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty(FACING, (Comparable)rot.rotate((EnumFacing)state.getValue(FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue(FACING)));
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        Material material = world.getBlockState(pos.down()).getMaterial();
        return !world.isAirBlock(pos.down()) && material.isOpaque() && material.isSolid();
    }

    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        world.spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.5, (double)y + 0.95, (double)z + 0.5, 0.0, 0.0, 0.0, new int[0]);
        if (((EnumFacing)state.getValue(FACING)).getAxis() == EnumFacing.Axis.X) {
            world.spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.5, (double)y + 0.9, (double)z + 0.15, 0.0, 0.0, 0.0, new int[0]);
            world.spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.5, (double)y + 0.9, (double)z + 0.85, 0.0, 0.0, 0.0, new int[0]);
        } else {
            world.spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.15, (double)y + 0.9, (double)z + 0.5, 0.0, 0.0, 0.0, new int[0]);
            world.spawnParticle(EnumParticleTypes.FLAME, (double)x + 0.85, (double)y + 0.9, (double)z + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue(FACING)).getHorizontalIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(FACING, (Comparable)EnumFacing.byHorizontalIndex((int)meta));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }
}

