/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityBrazier;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.Nullable;

public class BlockBrazier
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.95f, (double)0.8f);

    public BlockBrazier() {
        super(Material.IRON);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setHardness(3.5f);
        this.setSoundType(SoundType.METAL);
    }

    public static void tryIgnite(World world, BlockPos pos) {
        TileEntityBrazier brazier;
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileEntityBrazier && !(brazier = (TileEntityBrazier)tile).isEmpty()) {
            brazier.begin();
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntityBrazier brazier;
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileEntityBrazier && (brazier = (TileEntityBrazier)tile).isBurning()) {
            double d0 = (float)pos.getX() + 0.4f + (float)rand.nextInt(3) * 0.1f;
            double d2 = (float)pos.getY() + 1.1f + (float)rand.nextInt(2) * 0.1f;
            double d3 = (float)pos.getZ() + 0.4f + (float)rand.nextInt(3) * 0.1f;
            world.spawnParticle(EnumParticleTypes.FLAME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityBrazier tile = WitcheryTileEntities.BRAZIER.getAt((IBlockAccess)worldIn, pos);
        if (tile != null) {
            InventoryHelper.dropInventoryItems((World)worldIn, (BlockPos)pos, (IInventory)tile);
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState state, World world, BlockPos pos) {
        return Container.calcRedstoneFromInventory((IInventory)((IInventory)world.getTileEntity(pos)));
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        block10: {
            ItemStack stack;
            TileEntityBrazier brazier;
            block12: {
                block11: {
                    if (world.isRemote) {
                        return true;
                    }
                    TileEntity tile = world.getTileEntity(pos);
                    if (!(tile instanceof TileEntityBrazier)) break block10;
                    brazier = (TileEntityBrazier)tile;
                    stack = player.getHeldItem(hand);
                    if (stack.isEmpty()) {
                        return false;
                    }
                    if (stack.getItem() != Items.POTIONITEM || PotionUtils.getPotionFromItem((ItemStack)stack) != PotionTypes.WATER) break block11;
                    if (brazier.isEmpty()) break block10;
                    brazier.reset();
                    if (!player.capabilities.isCreativeMode && player.inventory != null) {
                        player.inventory.setInventorySlotContents(player.inventory.currentItem, new ItemStack(Items.GLASS_BOTTLE));
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                    world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SPLASH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    break block10;
                }
                if (stack.getItem() != Items.WATER_BUCKET) break block12;
                if (brazier.isEmpty()) break block10;
                brazier.reset();
                if (!player.capabilities.isCreativeMode && player.inventory != null) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, new ItemStack(Items.BUCKET));
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                    }
                }
                world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SPLASH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                break block10;
            }
            if (stack.getItem() == Items.FLINT_AND_STEEL) {
                if (!brazier.isEmpty()) {
                    brazier.begin();
                }
                return false;
            }
            for (int i = 0; i < brazier.getSizeInventory() - 1; ++i) {
                if (!brazier.getStackInSlot(i).isEmpty()) continue;
                if (!player.capabilities.isCreativeMode && player.inventory != null) {
                    ItemStack newStack = stack.splitStack(1);
                    brazier.setInventorySlotContents(i, newStack);
                    break;
                }
                brazier.setInventorySlotContents(i, new ItemStack(stack.getItem(), 1, stack.getItemDamage()));
                break;
            }
        }
        return true;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag = worldIn.isBlockPowered(pos);
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile instanceof TileEntityBrazier) {
            TileEntityBrazier brazier = (TileEntityBrazier)tile;
            if (brazier.previousRedstoneState != flag && flag && !brazier.isEmpty()) {
                brazier.begin();
            }
            brazier.previousRedstoneState = flag;
        }
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.BRAZIER.create();
    }
}

