/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public abstract class BlockBramble
extends Block {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.05f, 0.0, (double)0.05f, (double)0.95f, 1.0, (double)0.95f);

    public BlockBramble() {
        super(Material.PLANTS);
        this.setHardness(20.0f);
        this.setResistance(1000.0f);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean canPlaceBlockAt(World par1World, BlockPos pos) {
        return !par1World.isAirBlock(pos.down());
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkBlockCoordValid(worldIn, pos);
    }

    public abstract void onEntityCollision(World var1, BlockPos var2, IBlockState var3, Entity var4);

    protected final void checkBlockCoordValid(World par1World, BlockPos pos) {
        if (!this.canPlaceBlockAt(par1World, pos)) {
            this.dropBlockAsItem(par1World, pos, par1World.getBlockState(pos), 0);
            par1World.setBlockToAir(pos);
        }
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }
}

