/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.msrandom.witchery.block.BloodTrap;
import net.msrandom.witchery.block.entity.TileEntityBloodTrap;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockBloodPoppy
extends BlockContainer
implements BloodTrap,
IPlantable {
    public static final PropertyBool FULL = PropertyBool.create((String)"full");
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);

    public BlockBloodPoppy() {
        super(Material.PLANTS);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FULL, (Comparable)Boolean.valueOf(false)));
        this.setHardness(0.0f);
        this.setSoundType(SoundType.PLANT);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.getDefaultState().withProperty((IProperty)FULL, world.getBlockState(pos).getValue((IProperty)FULL));
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityBloodTrap rose;
        if (!world.isRemote && entity instanceof EntityPlayer && (rose = WitcheryTileEntities.BLOOD_TRAP.getAt((IBlockAccess)world, pos)) != null) {
            rose.storePlayer((EntityPlayer)entity);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.handleItem(world, WitcheryTileEntities.BLOOD_TRAP.getAt((IBlockAccess)world, pos), player, hand)) {
            return true;
        }
        return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public int damageDropped(IBlockState par1) {
        return 0;
    }

    public Item getItemDropped(IBlockState par1, Random rand, int fortune) {
        return null;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return WitcheryTileEntities.BLOOD_TRAP.create();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FULL, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)FULL) != false ? 1 : 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FULL}).build();
    }
}

