/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityBloodCrucible;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.VampireTransformation;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockBloodCrucible
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, (double)0.31f, 0.75);

    public BlockBloodCrucible() {
        super(Material.ROCK);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setResistance(1000.0f);
        this.setHardness(2.5f);
        this.setSoundType(SoundType.STONE);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            TileEntityBloodCrucible crucible = WitcheryTileEntities.BLOOD_CRUCIBLE.getAt((IBlockAccess)world, pos);
            if (crucible != null && world instanceof WorldServer) {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                ItemStack stack = player.getHeldItem(hand);
                VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
                if (transformation.getLevel() >= 10 && (crucible.isFull() || player.capabilities.isCreativeMode) && !stack.isEmpty()) {
                    boolean success = false;
                    if (stack.getItem() == WitcheryIngredientItems.ARTICHOKE) {
                        transformation.setUltimatePower(VampireTransformation.Ultimate.STORM);
                        transformation.setCharges(5);
                        playerEx.sync();
                        success = true;
                    } else if (stack.getItem() == WitcheryIngredientItems.BAT_WOOL) {
                        transformation.setUltimatePower(VampireTransformation.Ultimate.SWARM);
                        transformation.setCharges(5);
                        playerEx.sync();
                        success = true;
                    } else if (stack.getItem() == Items.BONE) {
                        transformation.setUltimatePower(VampireTransformation.Ultimate.FARM);
                        transformation.setCharges(5);
                        playerEx.sync();
                        success = true;
                    }
                    if (success) {
                        crucible.drainAll();
                        stack.shrink(1);
                        world.playSound(null, 0.5 + (double)x, (double)y, 0.5 + (double)z, SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.REDSTONE), world, 0.5 + (double)x, y, 0.5 + (double)z);
                    } else {
                        world.playSound(null, 0.5 + (double)x, (double)y, 0.5 + (double)z, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, 0.5 + (double)x, y, 0.5 + (double)z);
                    }
                } else {
                    world.playSound(null, 0.5 + (double)x, (double)y, 0.5 + (double)z, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, 0.5 + (double)x, y, 0.5 + (double)z);
                }
            }
            return true;
        }
        return true;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.BLOOD_CRUCIBLE.create();
    }
}

