/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityBeartrap;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.CreatureUtil;

public class BlockBeartrap
extends BlockContainer {
    public static final PropertyBool CLOSED = PropertyBool.create((String)"closed");
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.create((String)"axis", EnumFacing.Axis.class, axis -> axis != EnumFacing.Axis.Y);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.19999998807907104, (double)0.01f, 0.19999998807907104, (double)0.8f, (double)0.1f, (double)0.8f);
    private final boolean silvered;

    public BlockBeartrap(boolean silvered) {
        super(Material.IRON);
        this.silvered = silvered;
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setHardness(5.0f);
        this.setResistance(10.0f);
        this.setSoundType(SoundType.METAL);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)CLOSED, (Comparable)Boolean.valueOf(false)).withProperty(AXIS, (Comparable)EnumFacing.Axis.X));
    }

    public static boolean checkForHiddenTrap(EntityPlayer player, RayTraceResult mop) {
        TileEntityBeartrap tile;
        if (mop != null && mop.typeOfHit == RayTraceResult.Type.BLOCK && player.world.getBlockState(mop.getBlockPos()).getBlock() == WitcheryBlocks.BEARTRAP && (tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)player.world, mop.getBlockPos())) != null) {
            return tile.invisibleTo(player);
        }
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return WitcheryTileEntities.BEARTRAP.create().setSilvered(this.silvered);
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        if (rot.ordinal() % 2 == 1) {
            return state.withProperty(AXIS, (Comparable)(state.getValue(AXIS) == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.Y));
        }
        return state;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(AXIS, (Comparable)((meta & 1) == 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z)).withProperty((IProperty)CLOSED, (Comparable)Boolean.valueOf((meta & 2) > 0));
    }

    public int getMetaFromState(IBlockState state) {
        return (state.getValue(AXIS) == EnumFacing.Axis.X ? 0 : 1) | ((Boolean)state.getValue((IProperty)CLOSED) != false ? 2 : 0);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AXIS, CLOSED}).build();
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty(AXIS, (Comparable)placer.getHorizontalFacing().getAxis());
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.setBlockState(pos, state.withProperty(AXIS, (Comparable)entity.getHorizontalFacing().getAxis()));
        if (!world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntityBeartrap tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)world, pos);
            if (tile != null) {
                tile.owner = player.getGameProfile();
                tile.notifyBlockUpdate(false);
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.silvered) {
            return;
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity instanceof EntityLivingBase) {
            AxisAlignedBB trapBounds;
            EntityLivingBase living = (EntityLivingBase)entity;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            TileEntityBeartrap tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)world, pos);
            if (!(tile == null || ((Boolean)state.getValue((IProperty)CLOSED)).booleanValue() || world.getTotalWorldTime() <= tile.setTime + 20L || this.silvered && !CreatureUtil.isWerewolf(entity, false) || !(trapBounds = new AxisAlignedBB((double)x + BlockBeartrap.AABB.minX, (double)y + BlockBeartrap.AABB.minY, (double)z + BlockBeartrap.AABB.minZ, (double)x + BlockBeartrap.AABB.maxX, (double)y + BlockBeartrap.AABB.maxY, (double)z + BlockBeartrap.AABB.maxZ)).intersects(entity.getEntityBoundingBox()) || this.silvered && !tile.tryTrapWolf(living))) {
                boolean isCreative;
                boolean bl = isCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).capabilities.isCreativeMode;
                if (!isCreative) {
                    living.addPotionEffect(new PotionEffect(WitcheryPotionEffects.PARALYSED, 600, 2, true, true));
                }
                living.attackEntityFrom(DamageSource.ANVIL, 4.0f);
                world.playSound(null, pos, WitcherySounds.BLOCK_BEARTRAP_MANTRAP, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.25f, 0.5f, EnumParticleTypes.REDSTONE), world, pos);
                world.setBlockState(pos, state.withProperty((IProperty)CLOSED, (Comparable)Boolean.valueOf(true)));
                tile.setTime = world.getTotalWorldTime();
                tile.notifyBlockUpdate(true);
            }
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityBeartrap tile;
        if (!world.isRemote && (tile = WitcheryTileEntities.BEARTRAP.getAt((IBlockAccess)world, pos)) != null) {
            world.playSound(null, player.getPosition(), WitcherySounds.BLOCK_BEARTRAP_CLICK, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            boolean closed = (Boolean)state.getValue((IProperty)CLOSED) == false;
            world.setBlockState(pos, state.withProperty((IProperty)CLOSED, (Comparable)Boolean.valueOf(closed)));
            if (closed) {
                tile.setTime = world.getTotalWorldTime();
            }
        }
        return true;
    }
}

