/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityBarrier;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import org.jetbrains.annotations.Nullable;

public class BlockBarrier
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);

    public BlockBarrier() {
        super(Material.GLASS);
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setLightOpacity(0);
    }

    public static void setBlock(World world, BlockPos pos, int ticksUntilExpiration, boolean blocksPlayers, EntityPlayer owner) {
        BlockBarrier.setBlock(world, pos, ticksUntilExpiration, blocksPlayers, owner, false);
    }

    public static void setBlock(World world, BlockPos pos, int ticksUntilExpiration, boolean blocksPlayers, EntityPlayer owner, boolean skipCreate) {
        TileEntityBarrier entity;
        if (!skipCreate) {
            world.setBlockState(pos, WitcheryBlocks.BARRIER.getDefaultState(), 3);
        }
        if ((entity = WitcheryTileEntities.BARRIER.getAt((IBlockAccess)world, pos)) != null) {
            entity.setTicksUntilExpiration(ticksUntilExpiration);
            entity.setBlocksPlayers(blocksPlayers);
            entity.setOwner(owner);
        }
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        TileEntityBarrier tileEntity;
        if (world instanceof World && (tileEntity = WitcheryTileEntities.BARRIER.getAt(world, pos)) != null) {
            List players = ((World)world).getEntitiesWithinAABB(EntityPlayer.class, new AxisAlignedBB(pos, pos.add(1.0, 0.9, 1.0)));
            for (EntityPlayer player : players) {
                if (player == null || tileEntity.getBlocksPlayers() && (!player.capabilities.isCreativeMode || !player.isSneaking()) && !tileEntity.isOwner(player)) continue;
                return NULL_AABB;
            }
        }
        return AABB;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.getBlockState(pos.offset(side)).getBlock() != this && super.shouldSideBeRendered(blockState, blockAccess, pos, side);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.BARRIER.create();
    }
}

