/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.effect.RiteEffectCurseCreature;
import net.msrandom.witchery.rite.effect.RiteEffectTeleportEntity;
import org.jetbrains.annotations.Nullable;

public abstract class BlockAreaMarker
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.15f, 0.0, (double)0.15f, (double)0.85f, 0.5, (double)0.85f);

    public BlockAreaMarker() {
        super(Material.ROCK);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setBlockUnbreakable();
        this.setResistance(9999.0f);
        this.setHardness(2.5f);
        this.setSoundType(SoundType.STONE);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    protected abstract TileEntityType<? extends TileEntityAreaMarker> getEntity();

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return this.getEntity().create();
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (!world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntity tile = world.getTileEntity(pos);
            if (tile instanceof TileEntityAreaMarker) {
                TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
                marker.setOwnerId(player.getUniqueID());
            }
        }
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile;
        int x = pos.getX();
        int z = pos.getZ();
        if (!world.isRemote & player != null && (tile = world.getTileEntity(pos)) instanceof TileEntityAreaMarker) {
            TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
            if (player.capabilities.isCreativeMode || player.getName().equals(marker.getOwnerId()) && player.isSneaking()) {
                int dy = pos.getY();
                while (world.getBlockState(new BlockPos(x, dy, z)).getBlock() == this) {
                    world.setBlockToAir(new BlockPos(x, dy, z));
                    world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)x, 0.5 + (double)dy, 0.5 + (double)z, new ItemStack((Block)this)));
                    ++dy;
                }
            }
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileEntityAreaMarker) {
            TileEntityAreaMarker marker = (TileEntityAreaMarker)tile;
            return marker.activateBlock();
        }
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public static abstract class TileEntityAreaMarker
    extends WitcheryTileEntity {
        private static final String OWNER_KEY = "WitcheryPlacer";
        private final Set<UUID> killers = new HashSet<UUID>();
        private UUID owner;

        @Override
        protected void initiate() {
            super.initiate();
            if (!this.world.isRemote && this.world.getBlockState(this.getPos()).getBlock() == this.getExpectedBlockType()) {
                AreaMarkerRegistry.instance().add(this);
            }
        }

        public void invalidate() {
            super.invalidate();
            if (!this.world.isRemote) {
                AreaMarkerRegistry.instance().remove(this);
            }
        }

        public UUID getOwnerId() {
            return this.owner;
        }

        public void setOwnerId(UUID username) {
            this.owner = username;
        }

        public void addKiller(EntityPlayer player) {
            this.killers.add(player.getUniqueID());
        }

        public boolean checkIsProtected(EntityLivingBase entity, RiteEffect ritual) {
            if (this.isNear(entity)) {
                boolean killer = entity instanceof EntityPlayer && this.killers.contains(entity.getUniqueID());
                return this.isProtected(killer, ritual);
            }
            return false;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
            super.writeToNBT(nbtTag);
            if (this.getOwnerId() != null) {
                nbtTag.setUniqueId(OWNER_KEY, this.getOwnerId());
            }
            NBTTagList nbtKillers = new NBTTagList();
            for (UUID killer : this.killers) {
                nbtKillers.appendTag((NBTBase)new NBTTagString(killer.toString()));
            }
            nbtTag.setTag("Killers", (NBTBase)nbtKillers);
            return nbtTag;
        }

        public void readFromNBT(NBTTagCompound nbtTag) {
            super.readFromNBT(nbtTag);
            if (nbtTag.hasUniqueId(OWNER_KEY)) {
                this.owner = nbtTag.getUniqueId(OWNER_KEY);
            }
            NBTTagList nbtKillers = nbtTag.getTagList("Killers", 8);
            int count = nbtKillers.tagCount();
            for (int i = 0; i < count; ++i) {
                this.killers.add(UUID.fromString(nbtKillers.getStringTagAt(i)));
            }
        }

        public abstract boolean activateBlock();

        public abstract boolean isNear(EntityLivingBase var1);

        protected abstract boolean isProtected(boolean var1, RiteEffect var2);

        protected abstract Block getExpectedBlockType();
    }

    public static class AreaMarkerRegistry {
        private static final AreaMarkerRegistry INSTANCE = new AreaMarkerRegistry();
        public final Set<TileEntityAreaMarker> tiles = new HashSet<TileEntityAreaMarker>();

        public static AreaMarkerRegistry instance() {
            return INSTANCE;
        }

        private void add(TileEntityAreaMarker tile) {
            this.update(tile);
            this.tiles.add(tile);
        }

        private void remove(TileEntityAreaMarker tile) {
            this.tiles.remove((Object)tile);
            this.update(tile);
        }

        private void update(TileEntityAreaMarker tile) {
            this.tiles.removeIf(source -> source == null || source.isInvalid() || source.getPos().equals((Object)tile.getPos()));
        }

        public boolean isProtectionActive(EntityLivingBase entity, RiteEffect ritual) {
            for (TileEntityAreaMarker tile : this.tiles) {
                if (!tile.checkIsProtected(entity, ritual)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TileEntityAreaTeleportPullProtect
    extends TileEntityAreaMarker {
        @Override
        public boolean activateBlock() {
            return false;
        }

        @Override
        protected boolean isProtected(boolean killer, RiteEffect ritual) {
            return !killer && WitcheryConfigOptions.allowDecurseTeleport && (ritual == null || ritual instanceof RiteEffectTeleportEntity);
        }

        @Override
        public boolean isNear(EntityLivingBase entity) {
            int RADIUS = WitcheryConfigOptions.decurseTeleportPullRadius;
            int RADIUS_SQ = RADIUS * RADIUS;
            boolean inRange = this.getPos().distanceSq(entity.posX, (double)this.getPos().getY(), entity.posZ) <= (double)RADIUS_SQ;
            return inRange && this.world.provider.getDimension() == entity.dimension;
        }

        @Override
        protected Block getExpectedBlockType() {
            return WitcheryBlocks.DECURSE_TELEPORT;
        }
    }

    public static class DirectedDecurse
    extends BlockAreaMarker {
        @Override
        protected TileEntityType<? extends TileEntityAreaMarker> getEntity() {
            return WitcheryTileEntities.DIRECTED_DECURSE;
        }
    }

    public static class TeleportDecurse
    extends BlockAreaMarker {
        @Override
        protected TileEntityType<? extends TileEntityAreaMarker> getEntity() {
            return WitcheryTileEntities.TELEPORT_DECURSE;
        }
    }

    public static class TileEntityAreaCurseProtect
    extends TileEntityAreaMarker {
        @Override
        public boolean activateBlock() {
            return false;
        }

        @Override
        protected boolean isProtected(boolean killer, RiteEffect ritual) {
            return !killer && WitcheryConfigOptions.allowDecurseDirected && (ritual == null || ritual instanceof RiteEffectCurseCreature);
        }

        @Override
        public boolean isNear(EntityLivingBase entity) {
            int r = WitcheryConfigOptions.decurseDirectedRadius;
            int rSq = r * r;
            boolean inRange = this.getPos().distanceSq(entity.posX, (double)this.getPos().getY(), entity.posZ) <= (double)rSq;
            return inRange && this.world.provider.getDimension() == entity.dimension;
        }

        @Override
        protected Block getExpectedBlockType() {
            return WitcheryBlocks.DECURSE_DIRECTED;
        }
    }
}

