/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityAltar;
import net.msrandom.witchery.client.gui.GuiAltar;
import net.msrandom.witchery.client.particle.ParticleNaturePower;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockAltar
extends BlockContainer {
    private static final int ELEMENTS_IN_COMPLETE_ALTAR = 6;
    private static final PropertyBool JOINED = PropertyBool.create((String)"joined");

    public BlockAltar() {
        super(Material.ROCK);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)JOINED, (Comparable)Boolean.valueOf(false)));
        this.setHardness(2.0f);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return WitcheryTileEntities.ALTAR.create();
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        int i = Minecraft.getMinecraft().gameSettings.particleSetting;
        if (i == 2 || i == 1 && rand.nextInt(3) == 0) {
            return;
        }
        if (((Boolean)stateIn.getValue((IProperty)JOINED)).booleanValue()) {
            int plantZ;
            int plantY;
            int RADIUS = 16;
            int VERT = 4;
            int plantX = pos.getX() - RADIUS + rand.nextInt(32) + 1;
            Block block = world.getBlockState(new BlockPos(plantX, plantY = pos.getY() - VERT + rand.nextInt(8) + 1, plantZ = pos.getZ() - RADIUS + rand.nextInt(32) + 1)).getBlock();
            if (block instanceof BlockLeaves || block instanceof IPlantable) {
                int dir_x = pos.getX() - plantX;
                int dir_y = pos.getY() - plantY;
                int dir_z = pos.getZ() - plantZ;
                double distance = Math.sqrt(dir_x * dir_x + dir_y * dir_y + dir_z * dir_z);
                double speed = 0.25;
                ParticleNaturePower sparkle = new ParticleNaturePower(world, 0.5 + (double)plantX, 0.5 + (double)plantY, 0.5 + (double)plantZ);
                sparkle.setMaxAge((int)(distance / speed));
                sparkle.setCanMove(true);
                sparkle.setRBGColorF(0.2f, 0.8f, 0.0f);
                Minecraft.getMinecraft().effectRenderer.addEffect((Particle)sparkle);
            }
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityAltar tileEntity;
        if (playerIn.getHeldItem(hand).isEmpty() && (tileEntity = (TileEntityAltar)worldIn.getTileEntity(pos)).isValidAndUpdate()) {
            if (worldIn.isRemote) {
                this.openGui(tileEntity);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(TileEntityAltar altar) {
        Minecraft.getMinecraft().displayGuiScreen((GuiScreen)new GuiAltar(altar));
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
        this.updateMultiblock(worldIn, pos, null);
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        this.updateMultiblock(worldIn, pos, pos);
        super.breakBlock(worldIn, pos, state);
    }

    public void onExplosionDestroy(World worldIn, BlockPos pos, Explosion explosionIn) {
        worldIn.getTileEntity(pos);
        this.updateMultiblock(worldIn, pos, null);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity instanceof TileEntityAltar && !world.isRemote) {
            TileEntityAltar tileEntityAltar = (TileEntityAltar)tileEntity;
            tileEntityAltar.updateCoreArtefacts();
        }
        super.neighborChanged(state, world, pos, blockIn, fromPos);
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)JOINED) != false ? 1 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)JOINED, (Comparable)Boolean.valueOf(meta == 1));
    }

    private void updateMultiblock(World world, BlockPos pos, BlockPos exclude) {
        if (!world.isRemote) {
            ArrayList<BlockPos> visited = new ArrayList<BlockPos>();
            ArrayList<BlockPos> toVisit = new ArrayList<BlockPos>();
            toVisit.add(pos);
            boolean valid = true;
            while (toVisit.size() > 0) {
                BlockPos coord = (BlockPos)toVisit.get(0);
                toVisit.remove(0);
                int neighbours = 0;
                for (BlockPos newCoord : new BlockPos[]{coord.north(), coord.south(), coord.east(), coord.west()}) {
                    if (world.getBlockState(newCoord).getBlock() != this) continue;
                    if (!visited.contains(newCoord) && !toVisit.contains(newCoord)) {
                        toVisit.add(newCoord);
                    }
                    ++neighbours;
                }
                if (coord.equals((Object)exclude)) continue;
                if (neighbours < 2 || neighbours > 3) {
                    valid = false;
                }
                visited.add(coord);
            }
            BlockPos newCore = valid && visited.size() == 6 ? (BlockPos)visited.get(0) : null;
            for (BlockPos coord2 : visited) {
                this.updateState(world, coord2, newCore);
                TileEntity te = world.getTileEntity(coord2);
                if (!(te instanceof TileEntityAltar)) continue;
                TileEntityAltar tile = (TileEntityAltar)te;
                tile.setCore(newCore);
                tile.notifyBlockUpdate(true);
            }
            if (exclude != null) {
                this.updateState(world, exclude, newCore);
                TileEntity te2 = world.getTileEntity(exclude);
                if (te2 instanceof TileEntityAltar) {
                    TileEntityAltar tile2 = (TileEntityAltar)te2;
                    tile2.setCore(null);
                    tile2.notifyBlockUpdate(true);
                }
            }
        }
    }

    private void updateState(World world, BlockPos pos, BlockPos newCore) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == WitcheryBlocks.ALTAR) {
            world.setBlockState(pos, state.withProperty((IProperty)JOINED, (Comparable)Boolean.valueOf(newCore != null)), 3);
        }
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{JOINED}).build();
    }
}

