/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import org.jetbrains.annotations.Nullable;

public class BlockAlluringSkull
extends BlockContainer {
    public static final PropertyBool ON = PropertyBool.create((String)"on");
    private static final PropertyDirection FACING = BlockDirectional.FACING;
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75);

    public BlockAlluringSkull() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)ON, (Comparable)Boolean.valueOf(false)));
        this.setLightLevel(0.5f);
        this.setSoundType(SoundType.STONE);
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static void allure(World world, BlockPos pos, int quad) {
        AxisAlignedBB bounds;
        double posX = pos.getX();
        double posY = pos.getY();
        double posZ = pos.getZ();
        float r = 64.0f;
        float dy = 10.0f;
        switch (quad) {
            case 0: {
                bounds = new AxisAlignedBB(posX, posY - (double)dy, posZ - (double)r, posX + (double)r, posY, posZ);
                break;
            }
            case 1: {
                bounds = new AxisAlignedBB(posX - (double)r, posY - (double)dy, posZ - (double)r, posX, posY, posZ);
                break;
            }
            case 2: {
                bounds = new AxisAlignedBB(posX, posY - (double)dy, posZ, posX + (double)r, posY, posZ + (double)r);
                break;
            }
            case 3: {
                bounds = new AxisAlignedBB(posX - (double)r, posY - (double)dy, posZ, posX, posY, posZ + (double)r);
                break;
            }
            case 4: {
                bounds = new AxisAlignedBB(posX - (double)r, posY + 1.0, posZ - (double)r, posX, posY + (double)dy, posZ);
                break;
            }
            case 5: {
                bounds = new AxisAlignedBB(posX, posY + 1.0, posZ, posX + (double)r, posY + (double)dy, posZ + (double)r);
                break;
            }
            case 6: {
                bounds = new AxisAlignedBB(posX - (double)r, posY + 1.0, posZ, posX, posY + (double)dy, posZ + (double)r);
                break;
            }
            default: {
                bounds = new AxisAlignedBB(posX, posY + 1.0, posZ - (double)r, posX + (double)r, posY + (double)dy, posZ);
            }
        }
        for (EntityCreature creature : world.getEntitiesWithinAABB(EntityCreature.class, bounds)) {
            Path path;
            if (creature.getCreatureAttribute() != EnumCreatureAttribute.UNDEAD || creature.getNavigator().tryMoveToXYZ(posX, posY, posZ, 1.0) || (path = creature.getNavigator().getPathToEntityLiving((Entity)creature)) == null) continue;
            creature.getNavigator().setPath(path, (double)creature.getAIMoveSpeed());
        }
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        if (!world.isRemote && !(itemstack = player.getHeldItem(hand)).isEmpty() && itemstack.getItem() == WitcheryIngredientItems.NECRO_STONE) {
            if (!((Boolean)state.getValue((IProperty)ON)).booleanValue()) {
                world.playSound(null, 0.5 + (double)pos.getX(), 0.3 + (double)pos.getY(), 0.5 + (double)pos.getZ(), SoundEvents.ENTITY_SKELETON_HORSE_DEATH, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.getX(), 0.3 + (double)pos.getY(), 0.5 + (double)pos.getZ(), 0.5f, 0.5f, EnumParticleTypes.FLAME), world, 0.5 + (double)pos.getX(), 0.3 + (double)pos.getY(), 0.5 + (double)pos.getZ());
                world.setBlockState(pos, state.withProperty((IProperty)ON, (Comparable)Boolean.valueOf(true)));
            } else {
                world.playSound(null, 0.5 + (double)pos.getX(), 0.3 + (double)pos.getY(), 0.5 + (double)pos.getZ(), SoundEvents.ENTITY_SKELETON_HORSE_HURT, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.getX(), 0.3 + (double)pos.getY(), 0.5 + (double)pos.getZ(), 0.5f, 0.5f, EnumParticleTypes.EXPLOSION_NORMAL), world, 0.5 + (double)pos.getX(), 0.3 + (double)pos.getY(), 0.5 + (double)pos.getZ());
                world.setBlockToAir(pos);
                world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)pos.getX(), 0.8 + (double)pos.getY(), 0.5 + (double)pos.getZ(), new ItemStack((Block)WitcheryBlocks.ALLURING_SKULL)));
            }
            return true;
        }
        return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.getValue((IProperty)FACING)) {
            default: {
                return DEFAULT_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex() | ((Boolean)state.getValue((IProperty)ON) != false ? 8 : 0);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byIndex((int)(meta & 7))).withProperty((IProperty)ON, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING, ON}).build();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.ALLURING_SKULL.create();
    }
}

