/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryBlockDoor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0015\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002JP\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016\u00a8\u0006$"}, d2={"Lnet/msrandom/witchery/block/BlockAlderDoor;", "Lnet/msrandom/witchery/block/WitcheryBlockDoor;", "()V", "breakBlock", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "canProvidePower", "", "getStrongPower", "", "blockState", "blockAccess", "Lnet/minecraft/world/IBlockAccess;", "side", "Lnet/minecraft/util/EnumFacing;", "getWeakPower", "neighborChanged", "block", "Lnet/minecraft/block/Block;", "fromPos", "notifyUpdate", "onBlockActivated", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "hitX", "", "hitY", "hitZ", "WitcheryResurrected"})
public final class BlockAlderDoor
extends WitcheryBlockDoor {
    public boolean onBlockActivated(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        boolean result2 = super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        BlockPos blockPos = (BlockDoor.EnumDoorHalf)state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER ? pos.down() : pos;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"if (state.getValue(HALF)\u2026PPER) pos.down() else pos");
        this.notifyUpdate(world, blockPos);
        return result2;
    }

    public void breakBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        BlockPos blockPos = (BlockDoor.EnumDoorHalf)state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER ? pos.down() : pos;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"if (state.getValue(HALF)\u2026PPER) pos.down() else pos");
        this.notifyUpdate(world, blockPos);
        super.breakBlock(world, pos, state);
    }

    public int getWeakPower(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
        Intrinsics.checkParameterIsNotNull((Object)blockAccess, (String)"blockAccess");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        return BlockDoor.isOpen((IBlockAccess)blockAccess, (BlockPos)pos) ? 15 : 0;
    }

    public int getStrongPower(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)blockState, (String)"blockState");
        Intrinsics.checkParameterIsNotNull((Object)blockAccess, (String)"blockAccess");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        return side == EnumFacing.UP ? this.getWeakPower(blockState, blockAccess, pos, side) : 0;
    }

    public boolean canProvidePower(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return true;
    }

    public void neighborChanged(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        Intrinsics.checkParameterIsNotNull((Object)fromPos, (String)"fromPos");
        if ((BlockDoor.EnumDoorHalf)state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER) {
            boolean flag = false;
            IBlockState iBlockState = world.getBlockState(pos.up());
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos.up())");
            if (iBlockState.getBlock() != this) {
                world.setBlockToAir(pos);
                flag = true;
            }
            if (flag && !world.isRemote) {
                this.dropBlockAsItem(world, pos, state, 0);
            }
        }
        super.neighborChanged(state, world, pos, block, fromPos);
    }

    private final void notifyUpdate(World world, BlockPos pos) {
        world.notifyNeighborsRespectDebug(pos, (Block)this, true);
        world.notifyNeighborsRespectDebug(pos.down(), (Block)this, true);
    }

    public BlockAlderDoor() {
        Material material = Material.WOOD;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.WOOD");
        super(material);
        this.setHardness(5.0f);
        this.setSoundType(SoundType.WOOD);
    }
}

