/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.asm;

import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.msrandom.witchery.WitcheryModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class WitcheryLoadingPlugin
implements IFMLLoadingPlugin {
    private static File source;

    public String[] getASMTransformerClass() {
        return new String[]{Transformer.class.getName()};
    }

    public String getModContainerClass() {
        return WitcheryModContainer.class.getName();
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public static File getSource() {
        return source;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        source = (File)data.get("coremodLocation");
    }

    public static class Transformer
    implements IClassTransformer {
        private static final Logger LOGGER = LogManager.getLogger((String)WitcheryLoadingPlugin.class.getSimpleName());
        private static final String PACKAGE = "net/msrandom/witchery/";

        public byte[] transform(String name2, String transformedName, byte[] basicClass) {
            String internalClassName = name2.replace(".", "/");
            switch (transformedName) {
                case "net.minecraftforge.fml.common.InjectedModContainer": {
                    LOGGER.info("Patching InjectedModContainer");
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader(basicClass);
                    reader.accept((ClassVisitor)node, 0);
                    node.methods.stream().filter(method -> method.name.equals("isImmutable")).findAny().ifPresent(method -> {
                        LabelNode lastLabel = null;
                        InsnList instructions = method.instructions;
                        for (int i = 0; i < instructions.size(); ++i) {
                            AbstractInsnNode insn = instructions.get(i);
                            if (insn instanceof LabelNode) {
                                lastLabel = (LabelNode)insn;
                                continue;
                            }
                            if (lastLabel == null || insn.getOpcode() != 172) continue;
                            AbstractInsnNode first = instructions.getFirst();
                            instructions.insertBefore(first, (AbstractInsnNode)new VarInsnNode(25, 0));
                            instructions.insertBefore(first, (AbstractInsnNode)new MethodInsnNode(184, "net/msrandom/witchery/WitcheryModContainer", "isMutable", "(Lnet/minecraftforge/fml/common/ModContainer;)Z", false));
                            instructions.insertBefore(first, (AbstractInsnNode)new JumpInsnNode(153, lastLabel));
                            instructions.insertBefore(first, (AbstractInsnNode)new InsnNode(3));
                            instructions.insertBefore(first, (AbstractInsnNode)new InsnNode(172));
                            LOGGER.info("Patched return value of InjectedModContainer#isImmutable");
                            break;
                        }
                    });
                    ClassWriter writer = new ClassWriter(reader, 2);
                    node.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
                case "net.minecraft.entity.EntityAgeable": {
                    LOGGER.info("Patching EntityAgeable");
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader(basicClass);
                    reader.accept((ClassVisitor)node, 0);
                    node.methods.stream().filter(method -> method.name.equals("<init>")).findAny().ifPresent(method -> {
                        for (int i = 0; i < method.instructions.size(); ++i) {
                            if (method.instructions.get(i).getOpcode() != 177) continue;
                            AbstractInsnNode insn = method.instructions.get(i - 1);
                            method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                            method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "net/msrandom/witchery/common/events/CommonEventHandler", "constructEntity", "(Lnet/minecraft/entity/Entity;)Lkotlin/Unit;", false));
                            LOGGER.info("Patched end of EntityAgeable constructor");
                            break;
                        }
                    });
                    ClassWriter writer = new ClassWriter(reader, 0);
                    node.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
                case "net.minecraft.entity.player.EntityPlayer": {
                    LOGGER.info("Patching EntityPlayer");
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader(basicClass);
                    reader.accept((ClassVisitor)node, 0);
                    block24: for (MethodNode method2 : node.methods) {
                        block20 : switch (FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, method2.name, method2.desc)) {
                            case "updateSize": 
                            case "func_184808_cD": {
                                AbstractInsnNode insn;
                                int i;
                                int j = 0;
                                for (i = 0; i < method2.instructions.size(); ++i) {
                                    insn = method2.instructions.get(i);
                                    if (!(insn instanceof FrameNode) || j++ != 3) continue;
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "net/msrandom/witchery/util/ResizingUtils", "getPlayerWidth", "(Lnet/minecraft/entity/player/EntityPlayer;)F", false));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(56, 1));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "net/msrandom/witchery/util/ResizingUtils", "getPlayerHeight", "(Lnet/minecraft/entity/player/EntityPlayer;)F", false));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(56, 2));
                                    LOGGER.info("Patched EntityPlayer#updateSize");
                                    break block20;
                                }
                                continue block24;
                            }
                            case "getEyeHeight": 
                            case "func_70047_e": {
                                AbstractInsnNode insn;
                                int i;
                                for (i = 0; i < method2.instructions.size(); ++i) {
                                    if (method2.instructions.get(i).getOpcode() != 174) continue;
                                    insn = method2.instructions.get(i - 2);
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(23, 1));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "net/msrandom/witchery/util/ResizingUtils", "getPlayerEyeHeight", "(Lnet/minecraft/entity/player/EntityPlayer;F)F", false));
                                    method2.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(56, 1));
                                    LOGGER.info("Patched EntityPlayer#getEyeHeight");
                                    break block20;
                                }
                                break;
                            }
                        }
                    }
                    ClassWriter writer = new ClassWriter(reader, 3);
                    node.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
                case "net.minecraft.server.MinecraftServer": {
                    LOGGER.info("Patching MinecraftServer");
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader(basicClass);
                    reader.accept((ClassVisitor)node, 0);
                    for (MethodNode method3 : node.methods) {
                        String methodName = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, method3.name, method3.desc);
                        if (!methodName.equals("reload") && !methodName.equals("func_193031_aM")) continue;
                        for (int i = 0; i < method3.instructions.size(); ++i) {
                            String reload;
                            AbstractInsnNode insn = method3.instructions.get(i);
                            if (!(insn instanceof MethodInsnNode) || insn.getOpcode() != 182) continue;
                            MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
                            if (!FMLDeobfuscatingRemapper.INSTANCE.map(methodInsnNode.owner).contains("FunctionManager") || !(reload = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc)).equals("reload") && !reload.equals("func_193059_f")) continue;
                            VarInsnNode varInsnNode = new VarInsnNode(25, 0);
                            method3.instructions.insert((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)varInsnNode);
                            method3.instructions.insert((AbstractInsnNode)varInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "net/msrandom/witchery/WitcheryResurrected", "reloadDataHandlers", "(Ljava/lang/Object;)V", false));
                            LOGGER.info("Patched MinecraftServer#reload");
                        }
                    }
                    ClassWriter writer = new ClassWriter(reader, 0);
                    node.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
                case "net.minecraft.world.WorldServer": {
                    LOGGER.info("Patching WorldServer");
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader(basicClass);
                    reader.accept((ClassVisitor)node, 0);
                    for (MethodNode method4 : node.methods) {
                        String s = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(internalClassName, method4.name, method4.desc);
                        if (!s.equals("init") && !s.equals("func_175643_b")) continue;
                        for (int i = 0; i < method4.instructions.size(); ++i) {
                            AbstractInsnNode insn = method4.instructions.get(i);
                            if (!(insn instanceof FieldInsnNode) || insn.getOpcode() != 181) continue;
                            FieldInsnNode fieldInsnNode = (FieldInsnNode)insn;
                            String fieldName = FMLDeobfuscatingRemapper.INSTANCE.mapFieldName(fieldInsnNode.owner, fieldInsnNode.name, fieldInsnNode.desc);
                            if (!fieldName.equals("functionManager") && !fieldName.equals("field_193036_D")) continue;
                            VarInsnNode varInsnNode = new VarInsnNode(25, 0);
                            method4.instructions.insert((AbstractInsnNode)fieldInsnNode, (AbstractInsnNode)varInsnNode);
                            method4.instructions.insert((AbstractInsnNode)varInsnNode, (AbstractInsnNode)new MethodInsnNode(184, "net/msrandom/witchery/WitcheryResurrected", "reloadDataHandlers", "(Ljava/lang/Object;)V", false));
                            LOGGER.info("Patched WorldServer#init");
                        }
                    }
                    ClassWriter writer = new ClassWriter(reader, 0);
                    node.accept((ClassVisitor)writer);
                    return writer.toByteArray();
                }
            }
            return basicClass;
        }
    }
}

