/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/minecraft/world/loot/conditions/SurvivesExplosionCondition;", "Lnet/minecraft/world/storage/loot/conditions/LootCondition;", "()V", "testCondition", "", "rand", "Ljava/util/Random;", "lootContext", "Lnet/minecraft/world/storage/loot/LootContext;", "Companion", "Serializer", "WitcheryResurrected"})
public final class SurvivesExplosionCondition
implements LootCondition {
    private static final SurvivesExplosionCondition INSTANCE;
    public static final Companion Companion;

    public boolean testCondition(@NotNull Random rand, @NotNull LootContext lootContext) {
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)lootContext, (String)"lootContext");
        Entity entity = lootContext.getKillerPlayer();
        if (entity == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
        }
        NBTTagCompound data = ((EntityPlayer)entity).getEntityData();
        return !data.hasKey("LastExplosionSize") || rand.nextFloat() <= 1.0f / data.getFloat("LastExplosionSize");
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new SurvivesExplosionCondition();
        LootConditionManager.registerCondition((LootCondition.Serializer)new Serializer());
    }

    @JvmStatic
    public static final void init() {
        Companion.init();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/minecraft/world/loot/conditions/SurvivesExplosionCondition$Serializer;", "Lnet/minecraft/world/storage/loot/conditions/LootCondition$Serializer;", "Lnet/minecraft/world/loot/conditions/SurvivesExplosionCondition;", "()V", "deserialize", "json", "Lcom/google/gson/JsonObject;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "", "value", "Lcom/google/gson/JsonSerializationContext;", "WitcheryResurrected"})
    public static final class Serializer
    extends LootCondition.Serializer<SurvivesExplosionCondition> {
        public void serialize(@NotNull JsonObject json, @NotNull SurvivesExplosionCondition value, @NotNull JsonSerializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        }

        @NotNull
        public SurvivesExplosionCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return INSTANCE;
        }

        public Serializer() {
            super(new ResourceLocation("survives_explosion"), SurvivesExplosionCondition.class);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/minecraft/world/loot/conditions/SurvivesExplosionCondition$Companion;", "", "()V", "INSTANCE", "Lnet/minecraft/world/loot/conditions/SurvivesExplosionCondition;", "init", "", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        public final void init() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

