/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.loot.conditions;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.msrandom.witchery.util.KotlinGenericWorkarounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate;", "", "matchers", "", "Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$Matcher;", "(Ljava/util/List;)V", "forAbsent", "", "container", "Lnet/minecraft/block/state/BlockStateContainer;", "callback", "Lkotlin/Function1;", "", "matches", "", "state", "Lnet/minecraft/block/state/IBlockState;", "toJsonElement", "Lcom/google/gson/JsonElement;", "Companion", "ExactMatcher", "Matcher", "RangedMatcher", "WitcheryResurrected"})
public final class StatePropertiesPredicate {
    private final List<Matcher> matchers;
    @JvmField
    @NotNull
    public static final StatePropertiesPredicate EMPTY;
    public static final Companion Companion;

    public final boolean matches(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Block block = state.getBlock();
        Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"state.block");
        BlockStateContainer container = block.getBlockState();
        for (Matcher matcher : this.matchers) {
            BlockStateContainer blockStateContainer = container;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockStateContainer, (String)"container");
            if (matcher.test(blockStateContainer, state)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void forAbsent(@NotNull BlockStateContainer container, @NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Iterable $this$forEach$iv = this.matchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            void container$iv;
            Matcher it = (Matcher)element$iv;
            boolean bl = false;
            Matcher matcher = it;
            BlockStateContainer blockStateContainer = container;
            Function1<? super String, Unit> callback$iv = callback;
            boolean $i$f$ifAbsent = false;
            IProperty property$iv = container$iv.getProperty(this_$iv.getKey());
            if (property$iv != null) continue;
            callback$iv.invoke((Object)this_$iv.getKey());
        }
    }

    @NotNull
    public final JsonElement toJsonElement() {
        JsonElement jsonElement;
        if (this == EMPTY) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else {
            JsonObject json = new JsonObject();
            Collection collection = this.matchers;
            boolean bl = false;
            if (!collection.isEmpty()) {
                Iterable $this$forEach$iv = this.matchers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Matcher it = (Matcher)element$iv;
                    boolean bl2 = false;
                    json.add(it.getKey(), it.toJsonElement());
                }
            }
            jsonElement = (JsonElement)json;
        }
        return jsonElement;
    }

    private StatePropertiesPredicate(List<? extends Matcher> matchers) {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)matchers);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(matchers)");
        this.matchers = (List)immutableList;
    }

    static {
        Companion = new Companion(null);
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
        EMPTY = new StatePropertiesPredicate((List)immutableList);
    }

    public /* synthetic */ StatePropertiesPredicate(List matchers, DefaultConstructorMarker $constructor_marker) {
        this(matchers);
    }

    @JvmStatic
    @NotNull
    public static final StatePropertiesPredicate deserializeProperties(@Nullable JsonElement json) {
        return Companion.deserializeProperties(json);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\fH\u0086\bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J.\u0010\r\u001a\u00020\u000e\"\u000e\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H&J\b\u0010\u0015\u001a\u00020\u0016H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$Matcher;", "", "key", "", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "ifAbsent", "", "container", "Lnet/minecraft/block/state/BlockStateContainer;", "callback", "Lkotlin/Function1;", "test", "", "state", "Lnet/minecraft/block/state/IBlockState;", "T", "", "property", "Lnet/minecraft/block/properties/IProperty;", "toJsonElement", "Lcom/google/gson/JsonElement;", "WitcheryResurrected"})
    public static abstract class Matcher {
        @NotNull
        private final String key;

        public final boolean test(@NotNull BlockStateContainer container, @NotNull IBlockState state) {
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            IProperty property = container.getProperty(this.key);
            return property != null && KotlinGenericWorkarounds.isMatch(this, state, property);
        }

        public abstract <T extends Comparable<? super T>> boolean test(@NotNull IBlockState var1, @NotNull IProperty<T> var2);

        @NotNull
        public abstract JsonElement toJsonElement();

        public final void ifAbsent(@NotNull BlockStateContainer container, @NotNull Function1<? super String, Unit> callback) {
            int $i$f$ifAbsent = 0;
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            IProperty property = container.getProperty(this.getKey());
            if (property == null) {
                callback.invoke((Object)this.getKey());
            }
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public Matcher(@NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            this.key = key;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J.\u0010\b\u001a\u00020\t\"\u000e\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$ExactMatcher;", "Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$Matcher;", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "test", "", "T", "", "state", "Lnet/minecraft/block/state/IBlockState;", "property", "Lnet/minecraft/block/properties/IProperty;", "toJsonElement", "Lcom/google/gson/JsonPrimitive;", "WitcheryResurrected"})
    private static final class ExactMatcher
    extends Matcher {
        @NotNull
        private final String value;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <T extends Comparable<? super T>> boolean test(@NotNull IBlockState state, @NotNull IProperty<T> property) {
            Optional optional;
            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
            Intrinsics.checkParameterIsNotNull(property, (String)"property");
            Optional optional2 = optional = property.parseValue(this.value);
            Intrinsics.checkExpressionValueIsNotNull((Object)optional2, (String)"optional");
            if (!optional2.isPresent()) return false;
            Comparable comparable = state.getValue(property);
            Object object = optional.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"optional.get()");
            if (comparable.compareTo(object) != 0) return false;
            return true;
        }

        @NotNull
        public JsonPrimitive toJsonElement() {
            return new JsonPrimitive(this.value);
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public ExactMatcher(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            super(key);
            this.value = value;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J.\u0010\n\u001a\u00020\u000b\"\u000e\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$RangedMatcher;", "Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$Matcher;", "key", "", "min", "max", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMax", "()Ljava/lang/String;", "getMin", "test", "", "T", "", "state", "Lnet/minecraft/block/state/IBlockState;", "property", "Lnet/minecraft/block/properties/IProperty;", "toJsonElement", "Lcom/google/gson/JsonElement;", "WitcheryResurrected"})
    private static final class RangedMatcher
    extends Matcher {
        @Nullable
        private final String min;
        @Nullable
        private final String max;

        @Override
        public <T extends Comparable<? super T>> boolean test(@NotNull IBlockState state, @NotNull IProperty<T> property) {
            block6: {
                block7: {
                    Optional optional1;
                    Comparable value;
                    block4: {
                        block5: {
                            Optional optional;
                            Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                            Intrinsics.checkParameterIsNotNull(property, (String)"property");
                            value = state.getValue(property);
                            if (this.min == null) break block4;
                            Optional optional2 = optional = property.parseValue(this.min);
                            Intrinsics.checkExpressionValueIsNotNull((Object)optional2, (String)"optional");
                            if (!optional2.isPresent()) break block5;
                            Object object = optional.get();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"optional.get()");
                            if (value.compareTo(object) >= 0) break block4;
                        }
                        return false;
                    }
                    if (this.max == null) break block6;
                    Optional optional = optional1 = property.parseValue(this.max);
                    Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"optional1");
                    if (!optional.isPresent()) break block7;
                    Object object = optional1.get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"optional1.get()");
                    if (value.compareTo(object) <= 0) break block6;
                }
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public JsonElement toJsonElement() {
            JsonObject json = new JsonObject();
            if (this.min != null) {
                json.addProperty("min", this.min);
            }
            if (this.max != null) {
                json.addProperty("max", this.max);
            }
            return (JsonElement)json;
        }

        @Nullable
        public final String getMin() {
            return this.min;
        }

        @Nullable
        public final String getMax() {
            return this.max;
        }

        public RangedMatcher(@NotNull String key, @Nullable String min, @Nullable String max) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            super(key);
            this.min = min;
            this.max = max;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$Companion;", "", "()V", "EMPTY", "Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate;", "deserializeProperties", "json", "Lcom/google/gson/JsonElement;", "deserializeProperty", "Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate$Matcher;", "key", "", "getNullableString", "WitcheryResurrected"})
    public static final class Companion {
        private final Matcher deserializeProperty(String key, JsonElement json) {
            Matcher matcher;
            if (json.isJsonPrimitive()) {
                String s2;
                String string = s2 = json.getAsString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s2");
                matcher = new ExactMatcher(key, string);
            } else {
                String string;
                String s;
                String string2;
                JsonObject value = JsonUtils.getJsonObject((JsonElement)json, (String)"value");
                if (value.has("min")) {
                    JsonElement jsonElement = value.get("min");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"value[\"min\"]");
                    string2 = this.getNullableString(jsonElement);
                } else {
                    string2 = s = null;
                }
                if (value.has("max")) {
                    JsonElement jsonElement = value.get("max");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"value[\"max\"]");
                    string = this.getNullableString(jsonElement);
                } else {
                    string = null;
                }
                String s1 = string;
                matcher = s != null && Intrinsics.areEqual((Object)s, s1) ? (Matcher)new ExactMatcher(key, s) : (Matcher)new RangedMatcher(key, s, s1);
            }
            return matcher;
        }

        private final String getNullableString(JsonElement json) {
            return json.isJsonNull() ? null : json.getAsString();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final StatePropertiesPredicate deserializeProperties(@Nullable JsonElement json) {
            StatePropertiesPredicate statePropertiesPredicate;
            if (json != null && !json.isJsonNull()) {
                JsonObject properties2 = JsonUtils.getJsonObject((JsonElement)json, (String)"properties");
                ArrayList arrayList = Lists.newArrayList();
                Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
                List list2 = arrayList;
                Iterator iterator = properties2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void key;
                    Map.Entry entry2;
                    Map.Entry entry3 = entry2 = (Map.Entry)iterator.next();
                    boolean bl = false;
                    String string = (String)entry3.getKey();
                    entry3 = entry2;
                    bl = false;
                    JsonElement value = (JsonElement)entry3.getValue();
                    void v1 = key;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"key");
                    JsonElement jsonElement = value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"value");
                    list2.add(this.deserializeProperty((String)v1, jsonElement));
                }
                statePropertiesPredicate = new StatePropertiesPredicate(list2, null);
            } else {
                statePropertiesPredicate = EMPTY;
            }
            return statePropertiesPredicate;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

