/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.loot.conditions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/minecraft/world/loot/conditions/MatchToolCondition;", "Lnet/minecraft/world/storage/loot/conditions/LootCondition;", "predicate", "Lnet/minecraft/advancements/critereon/ItemPredicate;", "(Lnet/minecraft/advancements/critereon/ItemPredicate;)V", "testCondition", "", "rand", "Ljava/util/Random;", "context", "Lnet/minecraft/world/storage/loot/LootContext;", "Companion", "Serializer", "WitcheryResurrected"})
public final class MatchToolCondition
implements LootCondition {
    private final ItemPredicate predicate;
    public static final Companion Companion = new Companion(null);

    public boolean testCondition(@NotNull Random rand, @NotNull LootContext context) {
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Entity entity = context.getKillerPlayer();
        if (entity == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
        }
        return this.predicate.test(((EntityPlayer)entity).getHeldItemMainhand());
    }

    public MatchToolCondition(@NotNull ItemPredicate predicate2) {
        Intrinsics.checkParameterIsNotNull((Object)predicate2, (String)"predicate");
        this.predicate = predicate2;
    }

    static {
        LootConditionManager.registerCondition((LootCondition.Serializer)new Serializer());
    }

    @JvmStatic
    public static final void init() {
        Companion.init();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/minecraft/world/loot/conditions/MatchToolCondition$Serializer;", "Lnet/minecraft/world/storage/loot/conditions/LootCondition$Serializer;", "Lnet/minecraft/world/loot/conditions/MatchToolCondition;", "()V", "deserialize", "json", "Lcom/google/gson/JsonObject;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "", "value", "Lcom/google/gson/JsonSerializationContext;", "WitcheryResurrected"})
    public static final class Serializer
    extends LootCondition.Serializer<MatchToolCondition> {
        @NotNull
        public MatchToolCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            ItemPredicate itemPredicate = ItemPredicate.deserialize((JsonElement)json.get("predicate"));
            Intrinsics.checkExpressionValueIsNotNull((Object)itemPredicate, (String)"ItemPredicate.deserialize(json[\"predicate\"])");
            return new MatchToolCondition(itemPredicate);
        }

        public void serialize(@NotNull JsonObject json, @NotNull MatchToolCondition value, @NotNull JsonSerializationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            JsonObject obj = new JsonObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)((MatchToolCondition)value).predicate.enchantments, (String)"value.predicate.enchantments");
            EnchantmentPredicate[] enchantmentPredicateArray = ((MatchToolCondition)value).predicate.enchantments;
            boolean bl = false;
            EnchantmentPredicate[] enchantmentPredicateArray2 = enchantmentPredicateArray;
            boolean bl2 = false;
            if (!(enchantmentPredicateArray2.length == 0)) {
                JsonArray arr = new JsonArray();
                for (EnchantmentPredicate selector : ((MatchToolCondition)value).predicate.enchantments) {
                    JsonElement jsonElement;
                    JsonObject enchantment = new JsonObject();
                    if (selector.enchantment != null) {
                        enchantment.addProperty("enchantment", String.valueOf(ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)selector.enchantment)));
                    }
                    if (selector.levels.min == null && selector.levels.max == null) {
                        jsonElement = (JsonElement)JsonNull.INSTANCE;
                    } else if (selector.levels.min != null && Intrinsics.areEqual((Float)selector.levels.min, (Float)selector.levels.max)) {
                        jsonElement = (JsonElement)new JsonPrimitive((Number)selector.levels.min);
                    } else {
                        JsonObject jsonObject = new JsonObject();
                        if (selector.levels.min != null) {
                            jsonObject.addProperty("min", (Number)selector.levels.min);
                        }
                        if (selector.levels.max != null) {
                            jsonObject.addProperty("max", (Number)selector.levels.max);
                        }
                        jsonElement = (JsonElement)jsonObject;
                    }
                    JsonElement levels = jsonElement;
                    enchantment.add("levels", levels);
                    arr.add((JsonElement)enchantment);
                }
                obj.add("enchantments", (JsonElement)arr);
            }
            json.add("predicate", (JsonElement)obj);
        }

        public Serializer() {
            super(new ResourceLocation("match_tool"), MatchToolCondition.class);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lnet/minecraft/world/loot/conditions/MatchToolCondition$Companion;", "", "()V", "init", "", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        public final void init() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

