/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.tileentity.BuiltTileEntityType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0010J\u000f\u0010\b\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lnet/minecraft/tileentity/TileEntityType;", "T", "Lnet/minecraft/tileentity/TileEntity;", "", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "create", "()Lnet/minecraft/tileentity/TileEntity;", "getAt", "blockReader", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/tileentity/TileEntity;", "Builder", "WitcheryResurrected"})
public interface TileEntityType<T extends TileEntity> {
    @NotNull
    public Class<T> getEntityClass();

    @Nullable
    public T create();

    @Nullable
    public T getAt(@NotNull IBlockAccess var1, @NotNull BlockPos var2);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0010*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0010B%\b\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/minecraft/tileentity/TileEntityType$Builder;", "T", "Lnet/minecraft/tileentity/TileEntity;", "", "factory", "Lkotlin/Function0;", "blocks", "", "Lnet/minecraft/block/Block;", "(Lkotlin/jvm/functions/Function0;Ljava/util/Set;)V", "entityClass", "Ljava/lang/Class;", "build", "Lnet/minecraft/tileentity/TileEntityType;", "datafixerType", "entity", "Companion", "WitcheryResurrected"})
    public static final class Builder<T extends TileEntity> {
        private Class<T> entityClass;
        private final Function0<T> factory;
        private final Set<Block> blocks;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Builder<T> entity(@NotNull Class<T> entityClass) {
            Intrinsics.checkParameterIsNotNull(entityClass, (String)"entityClass");
            this.entityClass = entityClass;
            return this;
        }

        @NotNull
        public final TileEntityType<T> build(@Nullable Object datafixerType) {
            Class<T> clazz = this.entityClass;
            if (clazz == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"entityClass");
            }
            return new BuiltTileEntityType<T>(clazz, this.factory, this.blocks);
        }

        private Builder(Function0<? extends T> factory2, Set<? extends Block> blocks) {
            this.factory = factory2;
            this.blocks = blocks;
        }

        public /* synthetic */ Builder(Function0 factory2, Set blocks, DefaultConstructorMarker $constructor_marker) {
            this(factory2, blocks);
        }

        @JvmStatic
        @NotNull
        public static final <T extends TileEntity> Builder<T> create(@NotNull Function0<? extends T> factory2, Block ... validBlocks) {
            return Companion.create(factory2, validBlocks);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0002\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lnet/minecraft/tileentity/TileEntityType$Builder$Companion;", "", "()V", "create", "Lnet/minecraft/tileentity/TileEntityType$Builder;", "T", "Lnet/minecraft/tileentity/TileEntity;", "factory", "Lkotlin/Function0;", "validBlocks", "", "Lnet/minecraft/block/Block;", "(Lkotlin/jvm/functions/Function0;[Lnet/minecraft/block/Block;)Lnet/minecraft/tileentity/TileEntityType$Builder;", "WitcheryResurrected"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final <T extends TileEntity> Builder<T> create(@NotNull Function0<? extends T> factory2, Block ... validBlocks) {
                Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
                Intrinsics.checkParameterIsNotNull((Object)validBlocks, (String)"validBlocks");
                return new Builder(factory2, SetsKt.setOf((Object[])Arrays.copyOf(validBlocks, validBlocks.length)), null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Nullable
        public static <T extends TileEntity> T getAt(TileEntityType<T> $this, @NotNull IBlockAccess blockReader, @NotNull BlockPos pos) {
            Intrinsics.checkParameterIsNotNull((Object)blockReader, (String)"blockReader");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            return (T)blockReader.getTileEntity(pos);
        }
    }
}

