/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.ReloadListener;
import net.minecraft.resources.Resource;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \r2\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/minecraft/resources/JsonReloadListener;", "Lnet/minecraft/resources/ReloadListener;", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/google/gson/JsonElement;", "gson", "Lcom/google/gson/Gson;", "folder", "", "(Lcom/google/gson/Gson;Ljava/lang/String;)V", "prepare", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "Companion", "WitcheryResurrected"})
public abstract class JsonReloadListener
extends ReloadListener<Map<ResourceLocation, ? extends JsonElement>> {
    private final Gson gson;
    private final String folder;
    private static final Logger LOGGER;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(@NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull((Object)resourceManager, (String)"resourceManager");
        boolean bl = false;
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        int i = this.folder.length() + 1;
        for (ResourceLocation key : resourceManager.findResources(this.folder, prepare.1.INSTANCE)) {
            String string;
            Closeable closeable;
            String s = key.getPath();
            String string2 = key.getNamespace();
            Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"s");
            int n = s.length() - 5;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = closeable;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(i, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string;
            String string6 = string3;
            ResourceLocation id = new ResourceLocation(string6, string5);
            try {
                closeable = resourceManager.getResource(key);
                n = 0;
                Throwable throwable = null;
                try {
                    Resource resource = (Resource)closeable;
                    boolean bl3 = false;
                    Closeable closeable2 = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
                    boolean bl4 = false;
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = (BufferedReader)closeable2;
                        boolean bl5 = false;
                        JsonElement element = (JsonElement)JsonUtils.fromJson((Gson)this.gson, (Reader)reader, JsonElement.class);
                        if (element != null) {
                            boolean bl6 = map.put(id, element) == null;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            if (!bl6) {
                                boolean bl9 = false;
                                String string7 = "Duplicate data file ignored with ID " + id;
                                throw (Throwable)new IllegalStateException(string7.toString());
                            }
                        } else {
                            LOGGER.error("Couldn't load data file " + id + " from " + key + " as it's null or empty");
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't parse data file " + id + " from " + key, (Throwable)exception);
            }
        }
        return map;
    }

    public JsonReloadListener(@NotNull Gson gson, @NotNull String folder) {
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        this.gson = gson;
        this.folder = folder;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LogManager.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/minecraft/resources/JsonReloadListener$Companion;", "", "()V", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

