/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.msrandom.witchery.init.WitcheryEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  *\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001 B?\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lnet/minecraft/entity/BuiltEntityType;", "T", "Lnet/minecraft/entity/Entity;", "Lnet/minecraft/entity/EntityType;", "builder", "Lnet/minecraftforge/fml/common/registry/EntityEntryBuilder;", "entityClass", "Ljava/lang/Class;", "category", "Lnet/minecraft/entity/EnumCreatureType;", "factory", "Ljava/util/function/Function;", "Lnet/minecraft/world/World;", "(Lnet/minecraftforge/fml/common/registry/EntityEntryBuilder;Ljava/lang/Class;Lnet/minecraft/entity/EnumCreatureType;Ljava/util/function/Function;)V", "kotlin.jvm.PlatformType", "getEntityClass", "()Ljava/lang/Class;", "create", "world", "(Lnet/minecraft/world/World;)Lnet/minecraft/entity/Entity;", "egg", "primary", "", "secondary", "spawn", "spawns", "", "Lnet/msrandom/witchery/init/WitcheryEntities$SpawnEntry;", "unwrap", "Lnet/minecraftforge/fml/common/registry/EntityEntry;", "name", "Lnet/minecraft/util/ResourceLocation;", "Companion", "WitcheryResurrected"})
public final class BuiltEntityType<T extends Entity>
implements EntityType<T> {
    private final EntityEntryBuilder<T> builder;
    @NotNull
    private final Class<T> entityClass;
    private final EnumCreatureType category;
    private final Function<World, T> factory;
    private static final AtomicInteger ID;
    public static final Companion Companion;

    @Override
    @NotNull
    public T create(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        T t = this.factory.apply(world);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"factory.apply(world)");
        return (T)((Entity)t);
    }

    @NotNull
    public final BuiltEntityType<T> egg(int primary, int secondary) {
        this.builder.egg(primary, secondary);
        return this;
    }

    @NotNull
    public final BuiltEntityType<T> spawn(@NotNull Iterable<WitcheryEntities.SpawnEntry> spawns) {
        Intrinsics.checkParameterIsNotNull(spawns, (String)"spawns");
        EnumCreatureType enumCreatureType = this.category;
        if (enumCreatureType != null) {
            EnumCreatureType enumCreatureType2 = enumCreatureType;
            boolean bl = false;
            boolean bl2 = false;
            EnumCreatureType it = enumCreatureType2;
            boolean bl3 = false;
            for (WitcheryEntities.SpawnEntry spawn : spawns) {
                this.builder.spawn(it, spawn.getWeight(), spawn.getMin(), spawn.getMax(), (Iterable)spawn.getBiomes());
            }
        }
        return this;
    }

    @NotNull
    public final EntityEntry unwrap(@NotNull ResourceLocation name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        ((Map)WitcheryEntities.LOOT_TABLES).put(this.getEntityClass(), new ResourceLocation(name2.getNamespace(), "entities/" + name2.getPath()));
        EntityEntry entityEntry = this.builder.name(name2.getNamespace() + "." + name2.getPath()).id(name2, ID.getAndIncrement()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)entityEntry, (String)"builder.name(name.namesp\u2026etAndIncrement()).build()");
        return entityEntry;
    }

    @Override
    @NotNull
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public BuiltEntityType(@NotNull EntityEntryBuilder<T> builder, @NotNull Class<T> entityClass, @Nullable EnumCreatureType category, @NotNull Function<World, T> factory2) {
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(entityClass, (String)"entityClass");
        Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
        this.entityClass = entityClass;
        this.category = category;
        this.factory = factory2;
        EntityEntryBuilder entityEntryBuilder = builder.entity(this.getEntityClass()).factory(this.factory);
        Intrinsics.checkExpressionValueIsNotNull((Object)entityEntryBuilder, (String)"builder.entity(this.entityClass).factory(factory)");
        this.builder = entityEntryBuilder;
    }

    static {
        Companion = new Companion(null);
        ID = new AtomicInteger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/minecraft/entity/BuiltEntityType$Companion;", "", "()V", "ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

