package net.msrandom.multiplatform

import com.sun.source.tree.PrimitiveTypeTree
import com.sun.source.tree.Tree
import com.sun.tools.javac.comp.Enter
import com.sun.tools.javac.tree.JCTree
import com.sun.tools.javac.tree.JCTree.*
import com.sun.tools.javac.tree.TreeMaker
import com.sun.tools.javac.util.Context
import com.sun.tools.javac.util.List
import net.msrandom.multiplatform.annotations.Actual
import net.msrandom.multiplatform.bootstrap.ElementRemover
import javax.annotation.processing.ProcessingEnvironment
import javax.lang.model.type.TypeKind

typealias JavaCompilerList<T> = List<T>

/*fun typeDefault(expression: Tree): JCExpression {
    if (expression is PrimitiveTypeTree) {
        when (expression.primitiveTypeKind) {
            TypeKind.BOOLEAN -> TODO()
            TypeKind.BYTE -> TODO()
            TypeKind.SHORT -> TODO()
            TypeKind.INT -> TODO()
            TypeKind.LONG -> TODO()
            TypeKind.CHAR -> TODO()
            TypeKind.FLOAT -> TODO()
            TypeKind.DOUBLE -> TODO()
            TypeKind.VOID -> TODO()
            else -> throw UnsupportedOperationException()
        }
    }
}*/

fun stub(tree: JCVariableDecl) {
    // tree.init = typeDefault(tree.getType())
}

fun stub(tree: JCMethodDecl, context: Context) {
    /*val treeMaker = TreeMaker.instance(context)

    tree.body = treeMaker.Block(0, JavaCompilerList.of(treeMaker.Return(typeDefault(tree.returnType))))*/
}

fun JCTree.clone(context: Context): JCTree {
    val treeMaker = TreeMaker.instance(context)

    return when (this) {
        is JCMethodDecl -> {
            treeMaker.MethodDef(
                modifiers,
                getName(),
                returnType as JCExpression?,
                typeParameters,
                receiverParameter,
                parameters,
                throws,
                getBody(),
                getDefaultValue() as JCExpression?,
            ).also {
                it.pos = pos
                it.mods.pos = mods.pos

                it.mods.annotations.firstOrNull { annotation -> Actual::class.qualifiedName.equals(annotation.type?.toString()) }?.let { annotation ->
                    it.mods.annotations = JavaCompilerList.filter(it.mods.annotations, annotation)
                }
            }
        }

        is JCVariableDecl -> {
            treeMaker.VarDef(
                modifiers,
                getName(),
                getType() as JCExpression?,
                initializer,
            ).also {
                it.pos = pos
                it.mods.pos = mods.pos

                it.mods.annotations.firstOrNull { annotation -> Actual::class.qualifiedName.equals(annotation.type?.toString()) }?.let { annotation ->
                    it.mods.annotations = JavaCompilerList.filter(it.mods.annotations, annotation)
                }
            }
        }

        else -> {
            throw UnsupportedOperationException("Attempting to clone $kind")
        }
    }
}

fun JCClassDecl.prepareClass(processingEnvironment: ProcessingEnvironment, elementRemover: ElementRemover) {
    elementRemover(processingEnvironment, sym)

    sym = null
}

fun JCCompilationUnit.finalizeClass(context: Context) {
    Enter.instance(context).complete(JavaCompilerList.of(this), null)
}
