/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.utils;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import net.msrandom.minecraftcodev.core.utils.HashKt;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a2\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u001a:\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u0011\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "downloadTo", "", "uri", "Ljava/net/URI;", "output", "Ljava/nio/file/Path;", "download", "sha1", "", "isOffline", "", "alwaysRefresh", "downloadSuspend", "(Ljava/net/URI;Ljava/lang/String;Ljava/nio/file/Path;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "minecraft-codev-core"})
public final class DownloadKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"Download");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void downloadTo(URI uri, Path output) {
        Path path;
        logger.info("Downloading " + uri);
        Path path2 = output.getParent();
        if (path2 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        } else {
            path = null;
        }
        Closeable closeable = uri.toURL().openStream();
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(output, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable2 = outputStream;
            int n = 8192;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output2 = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)input);
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output2, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void download(@NotNull URI uri, @Nullable String sha1, @NotNull Path output, boolean isOffline, boolean alwaysRefresh) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(output, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            if (isOffline) {
                throw new GradleException("Tried to download or access " + uri + " in offline mode");
            }
            DownloadKt.downloadTo(uri, output);
        }
        if (sha1 != null) {
            if (!alwaysRefresh && HashKt.checkHash(output, sha1)) {
                logger.debug("Using cached file {} since metadata checksum {} matches", (Object)output, (Object)sha1);
                return;
            }
            if (isOffline) {
                throw new GradleException("Cached version of " + uri + " at " + output + " has mismatched hash, expected " + sha1 + ", can not redownload in offline mode");
            }
            DownloadKt.downloadTo(uri, output);
        }
        if (isOffline) {
            logger.debug("Using cached file {} without extra checksum validation due to being in offline mode", (Object)output);
            return;
        }
        if (!alwaysRefresh) {
            String hash;
            String string;
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("HEAD");
            String sha1Header = connection.getHeaderField("X-Checksum-Sha1");
            if (sha1Header != null) {
                string = sha1Header;
            } else {
                String etag = connection.getHeaderField("ETag");
                if (etag != null && StringsKt.startsWith$default((String)etag, (String)"{SHA1{", (boolean)false, (int)2, null)) {
                    String string2 = etag.substring(6, etag.length() - 2);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = hash = null;
                }
            }
            if (hash != null && HashKt.checkHash(output, hash)) {
                logger.debug("Using cached file {} since server-reported checksum {} matches", (Object)output, (Object)hash);
                return;
            }
        }
        DownloadKt.downloadTo(uri, output);
    }

    public static /* synthetic */ void download$default(URI uRI, String string, Path path, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        DownloadKt.download(uRI, string, path, bl, bl2);
    }

    @Nullable
    public static final Object downloadSuspend(@NotNull URI uri, @Nullable String sha1, @NotNull Path output, boolean isOffline, boolean alwaysRefresh, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, sha1, output, isOffline, alwaysRefresh, null){
            int label;
            final /* synthetic */ URI $uri;
            final /* synthetic */ String $sha1;
            final /* synthetic */ Path $output;
            final /* synthetic */ boolean $isOffline;
            final /* synthetic */ boolean $alwaysRefresh;
            {
                this.$uri = $uri;
                this.$sha1 = $sha1;
                this.$output = $output;
                this.$isOffline = $isOffline;
                this.$alwaysRefresh = $alwaysRefresh;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DownloadKt.download(this.$uri, this.$sha1, this.$output, this.$isOffline, this.$alwaysRefresh);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object downloadSuspend$default(URI uRI, String string, Path path, boolean bl, boolean bl2, Continuation continuation, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return DownloadKt.downloadSuspend(uRI, string, path, bl, bl2, (Continuation<? super Unit>)continuation);
    }
}

