/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.task;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.minecraftcodev.core.resolve.GetMinecraftFileKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftDownloadVariant;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTask;
import net.msrandom.minecraftcodev.core.utils.CacheKt;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lnet/msrandom/minecraftcodev/core/task/ResolveMinecraftMappings;", "Lnet/msrandom/minecraftcodev/core/task/CachedMinecraftTask;", "<init>", "()V", "version", "Lorg/gradle/api/provider/Property;", "", "getVersion", "()Lorg/gradle/api/provider/Property;", "server", "", "getServer", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "download", "", "minecraft-codev-core"})
public abstract class ResolveMinecraftMappings
extends CachedMinecraftTask {
    public ResolveMinecraftMappings() {
        this.getOutput().convention(this.getProject().getLayout().file(this.getVersion().zip((Provider)this.getServer(), (arg_0, arg_1) -> ResolveMinecraftMappings._init_$lambda$0(1.INSTANCE, arg_0, arg_1)).map(arg_0 -> ResolveMinecraftMappings._init_$lambda$2(arg_0 -> ResolveMinecraftMappings._init_$lambda$1(this, arg_0), arg_0))));
    }

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getServer();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    public final void download() {
        MinecraftVersionList versionList = this.getCacheParameters().versionList();
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        MinecraftVersionMetadata version = versionList.version((String)object);
        MinecraftDownloadVariant variant = (Boolean)this.getServer().get() != false ? MinecraftDownloadVariant.ServerMappings : MinecraftDownloadVariant.ClientMappings;
        Path output = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getOutput());
        Path path = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getCacheParameters().getDirectory());
        Object object2 = this.getCacheParameters().isOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Path path2 = GetMinecraftFileKt.downloadMinecraftFile(path, version, variant, (Boolean)object2);
        if (path2 == null) {
            throw new IllegalArgumentException(version.getId() + " does not have variant " + (Object)((Object)variant));
        }
        Path downloadPath = path2;
        Files.deleteIfExists(output);
        CacheKt.tryLink(output, downloadPath);
    }

    private static final Pair _init_$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final File _init_$lambda$1(ResolveMinecraftMappings this$0, Pair pair) {
        String v = (String)pair.component1();
        Boolean s = (Boolean)pair.component2();
        String variant = s != false ? "server" : "client";
        File file = this$0.getTemporaryDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getTemporaryDir(...)");
        return FilesKt.resolve((File)file, (String)("minecraft-" + variant + "-mappings-" + v + ".txt"));
    }

    private static final File _init_$lambda$2(Function1 $tmp0, Object in) {
        return (File)$tmp0.invoke(in);
    }
}

