/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.msrandom.minecraftcodev.core.MinecraftComponentMetadataRuleKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVariantFilesMetadata;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.jetbrains.annotations.NotNull;

@CacheableRule
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lnet/msrandom/minecraftcodev/core/MinecraftDependenciesOperatingSystemMetadataRule;", "Lorg/gradle/api/artifacts/ComponentMetadataRule;", "cacheDirectory", "Ljava/io/File;", "versions", "", "", "versionManifestUrl", "isOffline", "", "<init>", "(Ljava/io/File;Ljava/util/List;Ljava/lang/String;Z)V", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "execute", "", "context", "Lorg/gradle/api/artifacts/ComponentMetadataContext;", "minecraft-codev-core"})
@SourceDebugExtension(value={"SMAP\nMinecraftDependenciesOperatingSystemMetadataRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftDependenciesOperatingSystemMetadataRule.kt\nnet/msrandom/minecraftcodev/core/MinecraftDependenciesOperatingSystemMetadataRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n288#2,2:68\n1549#2:70\n1620#2,3:71\n*S KotlinDebug\n*F\n+ 1 MinecraftDependenciesOperatingSystemMetadataRule.kt\nnet/msrandom/minecraftcodev/core/MinecraftDependenciesOperatingSystemMetadataRule\n*L\n36#1:68,2\n45#1:70\n45#1:71,3\n*E\n"})
public abstract class MinecraftDependenciesOperatingSystemMetadataRule
implements ComponentMetadataRule {
    @NotNull
    private final File cacheDirectory;
    @NotNull
    private final List<String> versions;
    @NotNull
    private final String versionManifestUrl;
    private final boolean isOffline;

    @Inject
    public MinecraftDependenciesOperatingSystemMetadataRule(@NotNull File cacheDirectory, @NotNull List<String> versions, @NotNull String versionManifestUrl, boolean isOffline) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Intrinsics.checkNotNullParameter((Object)versionManifestUrl, (String)"versionManifestUrl");
        this.cacheDirectory = cacheDirectory;
        this.versions = versions;
        this.versionManifestUrl = versionManifestUrl;
        this.isOffline = isOffline;
    }

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    public void execute(@NotNull ComponentMetadataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = this.cacheDirectory.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        MinecraftVersionList versionList = MinecraftComponentMetadataRuleKt.getVersionList(path, this.versionManifestUrl, this.isOffline);
        ModuleVersionIdentifier id = context.getDetails().getId();
        Sequence libraries = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.versions), arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$0(versionList, arg_0)), arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$1(id, arg_0));
        Sequence classifierOperatingSystems = SequencesKt.flatMapIterable((Sequence)libraries, MinecraftDependenciesOperatingSystemMetadataRule::execute$lambda$5);
        for (Pair pair : SequencesKt.distinctBy((Sequence)classifierOperatingSystems, MinecraftDependenciesOperatingSystemMetadataRule::execute$lambda$6)) {
            String operatingSystem = (String)pair.component1();
            String file = (String)pair.component2();
            context.getDetails().addVariant(operatingSystem, "runtime", arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$12(arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$11(this, operatingSystem, file, arg_0), arg_0));
        }
    }

    private static final Iterable execute$lambda$0(MinecraftVersionList $versionList, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $versionList.version(it).getLibraries();
    }

    private static final boolean execute$lambda$1(ModuleVersionIdentifier $id, MinecraftVersionMetadata.Library it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName().getGroup(), (Object)$id.getGroup()) && Intrinsics.areEqual((Object)it.getName().getModule(), (Object)$id.getName()) && Intrinsics.areEqual((Object)it.getName().getVersion(), (Object)$id.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable execute$lambda$5(MinecraftVersionMetadata.Library it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable osName;
        Object $this$firstOrNull$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List $this$execute_u24lambda_u245_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (it.getName().getClassifier() != null) {
            Object v0;
            block4: {
                $this$firstOrNull$iv = it.getRules();
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    MinecraftVersionMetadata.Rule it2 = (MinecraftVersionMetadata.Rule)element$iv;
                    boolean bl2 = false;
                    if (!(it2.getAction() == MinecraftVersionMetadata.RuleAction.Allow)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            MinecraftVersionMetadata.Rule rule = v0;
            Iterable iterable = osName = rule != null && ($this$firstOrNull$iv = rule.getOs()) != null ? ((MinecraftVersionMetadata.Rule.OperatingSystem)$this$firstOrNull$iv).getName() : null;
            if (osName != null) {
                MinecraftVersionMetadata.Download download = it.getDownloads().getArtifact();
                Intrinsics.checkNotNull((Object)download);
                $this$execute_u24lambda_u245_u24lambda_u244.add(TuplesKt.to((Object)osName, (Object)StringsKt.substringAfterLast$default((String)download.getPath(), (char)'/', null, (int)2, null)));
            }
        }
        osName = it.getNatives().entrySet();
        List list2 = $this$execute_u24lambda_u245_u24lambda_u244;
        boolean $i$f$map = false;
        $this$firstOrNull$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            collection.add(TuplesKt.to((Object)key, (Object)StringsKt.substringAfterLast$default((String)((MinecraftVersionMetadata.Download)MapsKt.getValue(it.getDownloads().getClassifiers(), (Object)value)).getPath(), (char)'/', null, (int)2, null)));
        }
        list2.addAll((List)destination$iv$iv);
        return CollectionsKt.build((List)list);
    }

    private static final String execute$lambda$6(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String operatingSystem = (String)pair.component1();
        return operatingSystem;
    }

    private static final Unit execute$lambda$11$lambda$7(MinecraftDependenciesOperatingSystemMetadataRule this$0, String $operatingSystem, AttributeContainer attribute) {
        attribute.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)this$0.getObjectFactory().named(OperatingSystemFamily.class, $operatingSystem));
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$11$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$11$lambda$9(String $file, MutableVariantFilesMetadata files) {
        files.addFile($file);
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$11(MinecraftDependenciesOperatingSystemMetadataRule this$0, String $operatingSystem, String $file, VariantMetadata variant) {
        variant.attributes(arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$11$lambda$8(arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$11$lambda$7(this$0, $operatingSystem, arg_0), arg_0));
        variant.withFiles(arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$11$lambda$10(arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$11$lambda$9($file, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

