/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.utils;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\t\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"clientJarPath", "Ljava/nio/file/Path;", "cacheDirectory", "version", "", "commonJarPath", "getCacheDirectory", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "getCacheDirectoryProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getVanillaExtractJarPath", "variant", "minecraft-codev-core"})
public final class CacheKt {
    @NotNull
    public static final Provider<Directory> getCacheDirectoryProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = project.getLayout().dir(project.provider(() -> CacheKt.getCacheDirectoryProvider$lambda$0(project)));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.dir(proje\u2026acheDirectory(project) })");
        return provider;
    }

    @NotNull
    public static final File getCacheDirectory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = project.getGradle().getGradleUserHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.gradle.gradleUserHomeDir");
        return FilesKt.resolve((File)file, (String)"caches/minecraft-codev");
    }

    private static final Path getVanillaExtractJarPath(Path cacheDirectory, String version2, String variant) {
        Path path = cacheDirectory.resolve("vanilla-extracts").resolve(variant + "-" + version2 + ".jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cacheDirectory\n        .\u2026ypeDefinition.JAR_TYPE}\")");
        return path;
    }

    @NotNull
    public static final Path commonJarPath(@NotNull Path cacheDirectory, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return CacheKt.getVanillaExtractJarPath(cacheDirectory, version2, "common");
    }

    @NotNull
    public static final Path clientJarPath(@NotNull Path cacheDirectory, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return CacheKt.getVanillaExtractJarPath(cacheDirectory, version2, "client");
    }

    private static final File getCacheDirectoryProvider$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return CacheKt.getCacheDirectory($project);
    }
}

