/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.task;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.minecraftcodev.core.resolve.GetMinecraftFileKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftDownloadVariant;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTask;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0003R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lnet/msrandom/minecraftcodev/core/task/ResolveMinecraftMappings;", "Lnet/msrandom/minecraftcodev/core/task/CachedMinecraftTask;", "()V", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "server", "Lorg/gradle/api/provider/Property;", "", "getServer", "()Lorg/gradle/api/provider/Property;", "version", "", "getVersion", "download", "", "minecraft-codev-core"})
public abstract class ResolveMinecraftMappings
extends CachedMinecraftTask {
    public ResolveMinecraftMappings() {
        this.getOutput().convention(this.getProject().getLayout().file(this.getVersion().zip((Provider)this.getServer(), (arg_0, arg_1) -> ResolveMinecraftMappings._init_$lambda$0(1.INSTANCE, arg_0, arg_1)).map(arg_0 -> ResolveMinecraftMappings._init_$lambda$1((Function1)new Function1<Pair<? extends String, ? extends Boolean>, File>(){

            public final File invoke(Pair<String, Boolean> pair) {
                String v = (String)pair.component1();
                Boolean s = (Boolean)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                String variant = s != false ? "server" : "client";
                File file = this.getTemporaryDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"temporaryDir");
                return FilesKt.resolve((File)file, (String)("minecraft-" + variant + "-mappings-" + v + ".txt"));
            }
        }, arg_0))));
    }

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getServer();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    private final void download() {
        Path downloadPath;
        MinecraftVersionList versionList = this.getCacheParameters().versionList();
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"version.get()");
        MinecraftVersionMetadata version2 = versionList.version((String)object);
        Object object2 = this.getServer().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"server.get()");
        MinecraftDownloadVariant variant = (Boolean)object2 != false ? MinecraftDownloadVariant.ServerMappings : MinecraftDownloadVariant.ClientMappings;
        Path output = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getOutput());
        Path path = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getCacheParameters().getDirectory());
        Object object3 = this.getCacheParameters().getIsOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"cacheParameters.isOffline.get()");
        Path path2 = GetMinecraftFileKt.downloadMinecraftFile(path, version2, variant, (Boolean)object3);
        if (path2 == null) {
            throw new IllegalArgumentException(version2.getId() + " does not have variant " + variant);
        }
        Path path3 = downloadPath = path2;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, output, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
    }

    private static final Pair _init_$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final File _init_$lambda$1(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(in);
    }
}

