/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.task;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.resolve.VanillaSplittingStateKt;
import net.msrandom.minecraftcodev.core.task.CachedMinecraftTask;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0003R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lnet/msrandom/minecraftcodev/core/task/ResolveMinecraftCommon;", "Lnet/msrandom/minecraftcodev/core/task/CachedMinecraftTask;", "()V", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "version", "Lorg/gradle/api/provider/Property;", "", "getVersion", "()Lorg/gradle/api/provider/Property;", "extract", "", "minecraft-codev-core"})
public abstract class ResolveMinecraftCommon
extends CachedMinecraftTask {
    public ResolveMinecraftCommon() {
        this.getOutput().convention(this.getProject().getLayout().file(this.getVersion().map(arg_0 -> ResolveMinecraftCommon._init_$lambda$0((Function1)new Function1<String, File>(){

            public final File invoke(String it) {
                File file = this.getTemporaryDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"temporaryDir");
                return FilesKt.resolve((File)file, (String)("minecraft-common-" + it + ".jar"));
            }
        }, arg_0))));
    }

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @TaskAction
    private final void extract() {
        MinecraftVersionList versionList = this.getCacheParameters().versionList();
        Object object = this.getVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"version.get()");
        MinecraftVersionMetadata version2 = versionList.version((String)object);
        Path path = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getCacheParameters().getDirectory());
        Object object2 = this.getCacheParameters().getIsOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"cacheParameters.isOffline.get()");
        VanillaSplittingStateKt.setupCommon(path, version2, (Boolean)object2, Path_utilsKt.getAsPath((FileSystemLocationProperty)this.getOutput()));
    }

    private static final File _init_$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(in);
    }
}

