/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.task;

import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import net.msrandom.minecraftcodev.core.MinecraftComponentMetadataRuleKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.utils.CacheKt;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lnet/msrandom/minecraftcodev/core/task/CachedMinecraftParameters;", "", "()V", "directory", "Lorg/gradle/api/file/DirectoryProperty;", "getDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "isOffline", "Lorg/gradle/api/provider/Property;", "", "getIsOffline", "()Lorg/gradle/api/provider/Property;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "versionManifestUrl", "", "getVersionManifestUrl", "convention", "", "project", "Lorg/gradle/api/Project;", "versionList", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionList;", "minecraft-codev-core"})
public abstract class CachedMinecraftParameters {
    @NotNull
    private final DirectoryProperty directory;
    @NotNull
    private final Property<Boolean> isOffline;

    public CachedMinecraftParameters() {
        DirectoryProperty directoryProperty = this.getObjectFactory().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.directory = directoryProperty;
        Property property = this.getObjectFactory().property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"objectFactory.property(B\u2026an::class.javaObjectType)");
        this.isOffline = property;
    }

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    @Input
    @NotNull
    public abstract Property<String> getVersionManifestUrl();

    @Internal
    @NotNull
    public final DirectoryProperty getDirectory() {
        return this.directory;
    }

    @Internal
    @JvmName(name="getIsOffline")
    @NotNull
    public final Property<Boolean> getIsOffline() {
        return this.isOffline;
    }

    public final void convention(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.getVersionManifestUrl().convention((Object)"https://launchermeta.mojang.com/mc/game/version_manifest_v2.json");
        this.directory.convention(CacheKt.getCacheDirectoryProvider(project));
        this.isOffline.convention(project.provider(() -> CachedMinecraftParameters.convention$lambda$0(project)));
    }

    @NotNull
    public final MinecraftVersionList versionList() {
        Path path = Path_utilsKt.getAsPath((FileSystemLocationProperty)this.directory);
        Object object = this.getVersionManifestUrl().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"versionManifestUrl.get()");
        String string = (String)object;
        Object object2 = this.isOffline.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"isOffline.get()");
        return MinecraftComponentMetadataRuleKt.getVersionList(path, string, (Boolean)object2);
    }

    private static final Boolean convention$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return $project.getGradle().getStartParameter().isOffline();
    }
}

