/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core.resolve.bundled;

import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import net.msrandom.minecraftcodev.core.resolve.GetMinecraftFileKt;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import net.msrandom.minecraftcodev.core.resolve.legacy.LegacyJarSplitter;
import net.msrandom.minecraftcodev.core.utils.CacheKt;
import net.msrandom.minecraftcodev.core.utils.Path_utilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lnet/msrandom/minecraftcodev/core/resolve/bundled/BundledClientJarSplitter;", "", "()V", "split", "Ljava/nio/file/Path;", "cacheDirectory", "metadata", "Lnet/msrandom/minecraftcodev/core/resolve/MinecraftVersionMetadata;", "server", "isOffline", "", "split$minecraft_codev_core", "minecraft-codev-core"})
public final class BundledClientJarSplitter {
    @NotNull
    public static final BundledClientJarSplitter INSTANCE = new BundledClientJarSplitter();

    private BundledClientJarSplitter() {
    }

    @NotNull
    public final Path split$minecraft_codev_core(@NotNull Path cacheDirectory, @NotNull MinecraftVersionMetadata metadata, @NotNull Path server, boolean isOffline) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Path client = GetMinecraftFileKt.downloadMinecraftClient(cacheDirectory, metadata, isOffline);
        Path outputClient = CacheKt.clientJarPath(cacheDirectory, metadata.getId());
        Path path = outputClient.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputClient.parent");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        LegacyJarSplitter.INSTANCE.useFileSystems((Function1)new Function1<Function1<? super FileSystem, ? extends Unit>, Unit>(client, server, outputClient){
            final /* synthetic */ Path $client;
            final /* synthetic */ Path $server;
            final /* synthetic */ Path $outputClient;
            {
                this.$client = $client;
                this.$server = $server;
                this.$outputClient = $outputClient;
                super(1);
            }

            public final void invoke(@NotNull Function1<? super FileSystem, Unit> handle) {
                Intrinsics.checkNotNullParameter(handle, (String)"handle");
                FileSystem fileSystem = Path_utilsKt.zipFileSystem$default(this.$client, false, 2, null);
                handle.invoke((Object)fileSystem);
                FileSystem clientFs = fileSystem;
                FileSystem fileSystem2 = Path_utilsKt.zipFileSystem$default(this.$server, false, 2, null);
                handle.invoke((Object)fileSystem2);
                FileSystem serverFs = fileSystem2;
                FileSystem fileSystem3 = Path_utilsKt.zipFileSystem(this.$outputClient, true);
                handle.invoke((Object)fileSystem3);
                FileSystem newClientFs = fileSystem3;
                Path path = clientFs.getPath("/", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"clientFs.getPath(\"/\")");
                Path_utilsKt.walk(path, (Function1)new Function1<Sequence<? extends Path>, Unit>(serverFs, newClientFs){
                    final /* synthetic */ FileSystem $serverFs;
                    final /* synthetic */ FileSystem $newClientFs;
                    {
                        this.$serverFs = $serverFs;
                        this.$newClientFs = $newClientFs;
                        super(1);
                    }

                    public final void invoke(@NotNull Sequence<? extends Path> $this$walk) {
                        Intrinsics.checkNotNullParameter($this$walk, (String)"$this$walk");
                        for (Path clientEntry : $this$walk) {
                            Path path;
                            String name = ((Object)clientEntry).toString();
                            if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) continue;
                            Path serverEntry = this.$serverFs.getPath(name, new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)serverEntry, (String)"serverEntry");
                            LinkOption[] linkOptionArray = new LinkOption[]{};
                            if (!Files.notExists(serverEntry, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                            Path output = this.$newClientFs.getPath(name, new String[0]);
                            Path path2 = output.getParent();
                            if (path2 != null) {
                                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                                path = path3;
                                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
                            } else {
                                path = null;
                            }
                            Path path4 = clientEntry;
                            Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
                            Path path5 = output;
                            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
                            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path4, path5, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                        }
                    }
                });
                LegacyJarSplitter.INSTANCE.withAssets(clientFs, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(serverFs, newClientFs){
                    final /* synthetic */ FileSystem $serverFs;
                    final /* synthetic */ FileSystem $newClientFs;
                    {
                        this.$serverFs = $serverFs;
                        this.$newClientFs = $newClientFs;
                        super(1);
                    }

                    public final void invoke(@NotNull Path path) {
                        block6: {
                            Path path2;
                            Object object;
                            String name;
                            block5: {
                                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                                name = ((Object)path).toString();
                                Path path3 = this.$serverFs.getPath(name, new String[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"serverFs.getPath(\n      \u2026me,\n                    )");
                                Path path4 = path3;
                                object = new LinkOption[]{};
                                if (Files.notExists(path4, Arrays.copyOf(object, ((LinkOption[])object).length)) || StringsKt.contains$default((CharSequence)name, (CharSequence)"lang", (boolean)false, (int)2, null)) break block5;
                                Path path5 = path.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"path.parent");
                                if (!Intrinsics.areEqual((Object)PathsKt.getName((Path)path5), (Object)"assets") || !StringsKt.startsWith$default((CharSequence)PathsKt.getName((Path)path), (char)'.', (boolean)false, (int)2, null)) break block6;
                            }
                            Path newPath = this.$newClientFs.getPath(name, new String[0]);
                            Path path6 = newPath.getParent();
                            if (path6 != null) {
                                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                Path path7 = Files.createDirectories(path6, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                                path2 = path7;
                                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"createDirectories(...)");
                            } else {
                                path2 = null;
                            }
                            object = path;
                            Intrinsics.checkNotNullExpressionValue((Object)newPath, (String)"newPath");
                            Path path8 = newPath;
                            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
                            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, path8, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                        }
                    }
                }));
            }
        });
        return outputClient;
    }
}

