/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.core;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.msrandom.minecraftcodev.core.MinecraftComponentMetadataRuleKt;
import net.msrandom.minecraftcodev.core.MinecraftDependenciesOperatingSystemMetadataRule;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionList;
import net.msrandom.minecraftcodev.core.resolve.MinecraftVersionMetadata;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVariantFilesMetadata;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.jetbrains.annotations.NotNull;

@CacheableRule
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/minecraftcodev/core/MinecraftDependenciesOperatingSystemMetadataRule;", "Lorg/gradle/api/artifacts/ComponentMetadataRule;", "cacheDirectory", "Ljava/io/File;", "versions", "", "", "versionManifestUrl", "isOffline", "", "(Ljava/io/File;Ljava/util/List;Ljava/lang/String;Z)V", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "execute", "", "context", "Lorg/gradle/api/artifacts/ComponentMetadataContext;", "minecraft-codev-core"})
public abstract class MinecraftDependenciesOperatingSystemMetadataRule
implements ComponentMetadataRule {
    @NotNull
    private final File cacheDirectory;
    @NotNull
    private final List<String> versions;
    @NotNull
    private final String versionManifestUrl;
    private final boolean isOffline;

    @Inject
    public MinecraftDependenciesOperatingSystemMetadataRule(@NotNull File cacheDirectory, @NotNull List<String> versions, @NotNull String versionManifestUrl, boolean isOffline) {
        Intrinsics.checkNotNullParameter((Object)cacheDirectory, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Intrinsics.checkNotNullParameter((Object)versionManifestUrl, (String)"versionManifestUrl");
        this.cacheDirectory = cacheDirectory;
        this.versions = versions;
        this.versionManifestUrl = versionManifestUrl;
        this.isOffline = isOffline;
    }

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    public void execute(@NotNull ComponentMetadataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path path = this.cacheDirectory.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cacheDirectory.toPath()");
        MinecraftVersionList versionList = MinecraftComponentMetadataRuleKt.getVersionList(path, this.versionManifestUrl, this.isOffline);
        ModuleVersionIdentifier id = context.getDetails().getId();
        Sequence libraries2 = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)this.versions), (Function1)((Function1)new Function1<String, List<? extends MinecraftVersionMetadata.Library>>(versionList){
            final /* synthetic */ MinecraftVersionList $versionList;
            {
                this.$versionList = $versionList;
                super(1);
            }

            @NotNull
            public final List<MinecraftVersionMetadata.Library> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$versionList.version(it).getLibraries();
            }
        })), (Function1)((Function1)new Function1<MinecraftVersionMetadata.Library, Boolean>(id){
            final /* synthetic */ ModuleVersionIdentifier $id;
            {
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MinecraftVersionMetadata.Library it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName().getGroup(), (Object)this.$id.getGroup()) && Intrinsics.areEqual((Object)it.getName().getModule(), (Object)this.$id.getName()) && Intrinsics.areEqual((Object)it.getName().getVersion(), (Object)this.$id.getVersion());
            }
        }));
        Sequence classifierOperatingSystems2 = SequencesKt.flatMapIterable((Sequence)libraries2, (Function1)execute.classifierOperatingSystems.1.INSTANCE);
        for (Pair pair : SequencesKt.distinctBy((Sequence)classifierOperatingSystems2, (Function1)execute.1.INSTANCE)) {
            String operatingSystem = (String)pair.component1();
            String file = (String)pair.component2();
            context.getDetails().addVariant(operatingSystem, "runtime", arg_0 -> MinecraftDependenciesOperatingSystemMetadataRule.execute$lambda$0((Function1)new Function1<VariantMetadata, Unit>(this, operatingSystem, file){
                final /* synthetic */ MinecraftDependenciesOperatingSystemMetadataRule this$0;
                final /* synthetic */ String $operatingSystem;
                final /* synthetic */ String $file;
                {
                    this.this$0 = $receiver;
                    this.$operatingSystem = $operatingSystem;
                    this.$file = $file;
                    super(1);
                }

                public final void invoke(VariantMetadata variant) {
                    variant.attributes(arg_0 -> execute.2.invoke$lambda$0((Function1)new Function1<AttributeContainer, Unit>(this.this$0, this.$operatingSystem){
                        final /* synthetic */ MinecraftDependenciesOperatingSystemMetadataRule this$0;
                        final /* synthetic */ String $operatingSystem;
                        {
                            this.this$0 = $receiver;
                            this.$operatingSystem = $operatingSystem;
                            super(1);
                        }

                        public final void invoke(AttributeContainer attribute) {
                            attribute.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)this.this$0.getObjectFactory().named(OperatingSystemFamily.class, this.$operatingSystem));
                        }
                    }, arg_0));
                    variant.withFiles(arg_0 -> execute.2.invoke$lambda$1((Function1)new Function1<MutableVariantFilesMetadata, Unit>(this.$file){
                        final /* synthetic */ String $file;
                        {
                            this.$file = $file;
                            super(1);
                        }

                        public final void invoke(MutableVariantFilesMetadata files) {
                            files.addFile(this.$file);
                        }
                    }, arg_0));
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }

                private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }, arg_0));
        }
    }

    private static final void execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

