/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.minecraftcodev.accesswidener;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.accesswidener.AccessWidenerVisitor;
import net.msrandom.minecraftcodev.accesswidener.AccessModifierResolutionData;
import net.msrandom.minecraftcodev.accesswidener.AccessModifiers;
import net.msrandom.minecraftcodev.core.ResolutionData;
import net.msrandom.minecraftcodev.core.ResolutionRule;
import net.msrandom.minecraftcodev.core.ResolutionRuleKt;
import net.msrandom.minecraftcodev.core.ZipResolutionRule;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0016"}, d2={"Lnet/msrandom/minecraftcodev/accesswidener/AccessWidenerExtension;", "", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/Project;)V", "accessWidenerResolution", "Lorg/gradle/api/provider/ListProperty;", "Lnet/msrandom/minecraftcodev/core/ResolutionRule;", "Lnet/msrandom/minecraftcodev/accesswidener/AccessModifierResolutionData;", "getAccessWidenerResolution", "()Lorg/gradle/api/provider/ListProperty;", "zipAccessWidenerResolution", "Lnet/msrandom/minecraftcodev/core/ZipResolutionRule;", "getZipAccessWidenerResolution", "loadAccessWideners", "Lnet/msrandom/minecraftcodev/accesswidener/AccessModifiers;", "files", "Lorg/gradle/api/file/FileCollection;", "namespace", "", "minecraft-codev-access-widener"})
@SourceDebugExtension(value={"SMAP\nAccessWidenerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessWidenerExtension.kt\nnet/msrandom/minecraftcodev/accesswidener/AccessWidenerExtension\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 4 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,77:1\n82#2:78\n32#3:79\n80#4:80\n*S KotlinDebug\n*F\n+ 1 AccessWidenerExtension.kt\nnet/msrandom/minecraftcodev/accesswidener/AccessWidenerExtension\n*L\n47#1:78\n47#1:79\n47#1:80\n*E\n"})
public class AccessWidenerExtension {
    @NotNull
    private final Project project;
    @NotNull
    private final ListProperty<ZipResolutionRule<AccessModifierResolutionData>> zipAccessWidenerResolution;
    @NotNull
    private final ListProperty<ResolutionRule<AccessModifierResolutionData>> accessWidenerResolution;

    public AccessWidenerExtension(@NotNull ObjectFactory objectFactory, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.zipAccessWidenerResolution = ResolutionRuleKt.zipResolutionRules((ObjectFactory)objectFactory);
        this.accessWidenerResolution = ResolutionRuleKt.resolutionRules((ObjectFactory)objectFactory, this.zipAccessWidenerResolution);
        this.accessWidenerResolution.add(AccessWidenerExtension::_init_$lambda$1);
        this.accessWidenerResolution.add(AccessWidenerExtension::_init_$lambda$3);
    }

    @NotNull
    public final ListProperty<ZipResolutionRule<AccessModifierResolutionData>> getZipAccessWidenerResolution() {
        return this.zipAccessWidenerResolution;
    }

    @NotNull
    public final ListProperty<ResolutionRule<AccessModifierResolutionData>> getAccessWidenerResolution() {
        return this.accessWidenerResolution;
    }

    @NotNull
    public final AccessModifiers loadAccessWideners(@NotNull FileCollection files, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        AccessModifiers widener = new AccessModifiers(false, namespace, null, 4, null);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        Intrinsics.checkNotNullExpressionValue((Object)md, (String)"md");
        AccessModifierResolutionData data = new AccessModifierResolutionData(widener, md, namespace);
        block0: for (File file : files) {
            for (ResolutionRule rule : (List)this.accessWidenerResolution.get()) {
                Path path = file.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (!rule.load(path, FilesKt.getExtension((File)file), (ResolutionData)data)) continue;
                continue block0;
            }
        }
        return widener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean _init_$lambda$1(Path path, String extension, AccessModifierResolutionData data) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        String string = extension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)"accesswidener")) {
            return false;
        }
        AccessWidenerReader reader = new AccessWidenerReader((AccessWidenerVisitor)data.getVisitor());
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = data.decorate(inputStream);
        Object object = Charsets.UTF_8;
        Reader reader2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            reader.read(it, data.getNamespace());
            reader2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean _init_$lambda$3(Path path, String extension, AccessModifierResolutionData data) {
        AccessModifiers accessModifiers;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        String string = extension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)"json")) {
            return false;
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = data.decorate(inputStream);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Json $this$decodeFromStream$iv = (Json)Json.Default;
            boolean $i$f$decodeFromStream = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromStream$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(AccessModifiers.class));
            boolean $i$f$cast = false;
            accessModifiers = (AccessModifiers)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)$this$cast$iv$iv$iv), (InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        AccessModifiers modifiers = accessModifiers;
        ((AccessModifiers)data.getVisitor()).visit(modifiers);
        return true;
    }
}

