/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.stubs;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.msrandom.stubs.StubGenerator;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b\"\u00020\u001c\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0017H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lnet/msrandom/stubs/GenerateStubApi;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "classpaths", "Lorg/gradle/api/provider/ListProperty;", "Lnet/msrandom/stubs/GenerateStubApi$Classpath;", "getClasspaths", "()Lorg/gradle/api/provider/ListProperty;", "apiFileName", "Lorg/gradle/api/provider/Property;", "", "getApiFileName", "()Lorg/gradle/api/provider/Property;", "outputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "classpath", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "extraFiles", "", "", "(Lorg/gradle/api/artifacts/Configuration;[Ljava/lang/Object;)V", "Lorg/gradle/api/provider/Provider;", "(Lorg/gradle/api/provider/Provider;[Ljava/lang/Object;)V", "generateStub", "Classpath", "classpath-api-stubs"})
public abstract class GenerateStubApi
extends DefaultTask {
    public GenerateStubApi() {
        this.getApiFileName().convention((Object)"api-stub.jar");
        this.getOutputDirectory().convention(this.getProject().getLayout().dir(this.getProject().provider(() -> GenerateStubApi._init_$lambda$0(this))));
    }

    @Nested
    @NotNull
    public abstract ListProperty<Classpath> getClasspaths();

    @Input
    @NotNull
    public abstract Property<String> getApiFileName();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDirectory();

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    public final void classpath(@NotNull Configuration configuration, Object ... extraFiles) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)extraFiles, (String)"extraFiles");
        Object object = this.getObjectFactory().newInstance(Classpath.class, new Object[0]);
        Classpath it = (Classpath)object;
        boolean bl = false;
        it.getArtifacts().set((Object)configuration.getIncoming().getArtifacts());
        Object[] objectArray = new Object[]{extraFiles};
        it.getExtraFiles().from(objectArray);
        Classpath classpath = (Classpath)object;
        this.getClasspaths().add((Object)classpath);
    }

    public final void classpath(@NotNull Provider<Configuration> configuration, Object ... extraFiles) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)extraFiles, (String)"extraFiles");
        Object object = this.getObjectFactory().newInstance(Classpath.class, new Object[0]);
        Classpath it = (Classpath)object;
        boolean bl = false;
        it.getArtifacts().set(configuration.map(arg_0 -> GenerateStubApi.classpath$lambda$4$lambda$3(GenerateStubApi::classpath$lambda$4$lambda$2, arg_0)));
        Object[] objectArray = new Object[]{extraFiles};
        it.getExtraFiles().from(objectArray);
        Classpath classpath = (Classpath)object;
        this.getClasspaths().add((Object)classpath);
    }

    @TaskAction
    public final void generateStub() {
        Path outputDirectory = ((File)this.getOutputDirectory().getAsFile().get()).toPath();
        Path apiFile = outputDirectory.resolve((String)this.getApiFileName().get());
        Object object = this.getClasspaths().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable iterable = (Iterable)object;
        Intrinsics.checkNotNull((Object)apiFile);
        List<ResolvedArtifactResult> extras = StubGenerator.INSTANCE.generateStub(iterable, apiFile);
        for (ResolvedArtifactResult artifact : extras) {
            Path path;
            Path path2;
            String string = artifact.getId().getComponentIdentifier().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            Path directory = outputDirectory.resolve(StringsKt.replace$default((String)string, (char)':', (char)'_', (boolean)false, (int)4, null));
            Intrinsics.checkNotNull((Object)directory);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(directory, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            Intrinsics.checkNotNullExpressionValue((Object)artifact.getFile().toPath(), (String)"toPath(...)");
            Intrinsics.checkNotNullExpressionValue((Object)directory.resolve(artifact.getFile().getName()), (String)"resolve(...)");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
    }

    private static final File _init_$lambda$0(GenerateStubApi this$0) {
        return this$0.getTemporaryDir();
    }

    private static final ArtifactCollection classpath$lambda$4$lambda$2(Configuration it) {
        return it.getIncoming().getArtifacts();
    }

    private static final ArtifactCollection classpath$lambda$4$lambda$3(Function1 $tmp0, Object in) {
        return (ArtifactCollection)$tmp0.invoke(in);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/stubs/GenerateStubApi$Classpath;", "", "artifacts", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "getArtifacts", "()Lorg/gradle/api/provider/Property;", "extraFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getExtraFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classpath-api-stubs"})
    public static interface Classpath {
        @Internal
        @NotNull
        public Property<ArtifactCollection> getArtifacts();

        @InputFiles
        @NotNull
        public ConfigurableFileCollection getExtraFiles();
    }
}

