/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.atload;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.msrandom.atload.ClientGameStarter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessTransformerFinder {
    private static final Logger LOGGER = LogManager.getLogger((String)"GradleStart");
    private static final String MOD_ATD_CLASS = "net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer";
    private static final String MOD_AT_METHOD = "addJar";

    public static void searchClasspath() {
        AtRegistrar atRegistrar = new AtRegistrar();
        URLClassLoader urlClassLoader = (URLClassLoader)ClientGameStarter.class.getClassLoader();
        for (URL url : urlClassLoader.getURLs()) {
            try {
                AccessTransformerFinder.searchMod(url, atRegistrar);
            }
            catch (IOException | IllegalAccessException | InvocationTargetException | URISyntaxException e) {
                LOGGER.warn("AccessTransformerFinder failed to search for mod jar at url {}", (Object)url, (Object)e);
            }
        }
    }

    private static void searchMod(URL url, AtRegistrar atRegistrar) throws IOException, InvocationTargetException, IllegalAccessException, URISyntaxException {
        if (!url.getProtocol().startsWith("file")) {
            return;
        }
        File mod = new File(url.toURI().getPath());
        if (!mod.exists()) {
            return;
        }
        if (mod.toString().endsWith("jar")) {
            try (JarFile jar = new JarFile(mod);){
                Manifest manifest = jar.getManifest();
                if (manifest != null) {
                    atRegistrar.addJar(jar, manifest);
                }
            }
        }
    }

    public static final class Remapper
    implements IClassTransformer {
        public Remapper() {
            this.doStuff((LaunchClassLoader)this.getClass().getClassLoader());
        }

        private void doStuff(LaunchClassLoader classloader) {
            Collection modifiers;
            Class<?> clazz = null;
            IClassTransformer instance = null;
            for (IClassTransformer transformer : classloader.getTransformers()) {
                if (!transformer.getClass().getCanonicalName().endsWith(AccessTransformerFinder.MOD_ATD_CLASS)) continue;
                clazz = transformer.getClass();
                instance = transformer;
            }
            if (clazz == null) {
                LOGGER.log(Level.ERROR, "ModAccessTransformer was somehow not found.");
                return;
            }
            try {
                Field f = clazz.getSuperclass().getDeclaredFields()[1];
                f.setAccessible(true);
                modifiers = ((Multimap)f.get(instance)).values();
            }
            catch (Throwable t) {
                LOGGER.log(Level.ERROR, "AccessTransformer.modifiers field was somehow not found...");
                return;
            }
            if (modifiers.isEmpty()) {
                return;
            }
            Field nameField = null;
            try {
                Optional mod = modifiers.stream().findFirst();
                nameField = mod.get().getClass().getFields()[0];
                nameField.setAccessible(true);
            }
            catch (Throwable t) {
                LOGGER.log(Level.ERROR, "AccessTransformer.Modifier.name field was somehow not found...");
            }
            HashMap nameMap = Maps.newHashMap();
            try {
                this.readCsv(this.getClass().getResourceAsStream("/fields.csv"), nameMap);
                this.readCsv(this.getClass().getResourceAsStream("/methods.csv"), nameMap);
            }
            catch (IOException e) {
                LOGGER.log(Level.ERROR, "Could not load CSV files!");
                e.printStackTrace();
                return;
            }
            for (Object modifier : modifiers) {
                try {
                    String name = (String)nameField.get(modifier);
                    String newName = (String)nameMap.get(name);
                    if (newName == null) continue;
                    nameField.set(modifier, newName);
                }
                catch (Exception exception) {}
            }
        }

        private void readCsv(InputStream file, Map<String, String> map) throws IOException {
            LOGGER.log(Level.DEBUG, "Reading CSV file: {}", (Object)file);
            Splitter split = Splitter.on((char)',').trimResults().limit(3);
            Scanner scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("searge")) continue;
                List splits = split.splitToList((CharSequence)line);
                map.put((String)splits.get(0), (String)splits.get(1));
            }
        }

        public byte[] transform(String name, String transformedName, byte[] basicClass) {
            return basicClass;
        }
    }

    private static final class AtRegistrar {
        private static final Attributes.Name FMLAT = new Attributes.Name("FMLAT");
        @Nullable
        private Method addJar = null;

        private AtRegistrar() {
            try {
                Class<?> modAtdClass = Class.forName(AccessTransformerFinder.MOD_ATD_CLASS);
                try {
                    this.addJar = modAtdClass.getDeclaredMethod(AccessTransformerFinder.MOD_AT_METHOD, JarFile.class, String.class);
                }
                catch (NoSuchMethodException | SecurityException ignored) {
                    LOGGER.error("Failed to find method {}.{}", (Object)AccessTransformerFinder.MOD_ATD_CLASS, (Object)AccessTransformerFinder.MOD_AT_METHOD);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Failed to find class {}", (Object)AccessTransformerFinder.MOD_ATD_CLASS);
            }
        }

        public void addJar(JarFile jarFile, Manifest manifest) throws InvocationTargetException, IllegalAccessException {
            String ats;
            if (this.addJar != null && (ats = manifest.getMainAttributes().getValue(FMLAT)) != null && !ats.isEmpty()) {
                this.addJar.invoke(null, jarFile, ats);
            }
        }
    }
}

