/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import org.parchmentmc.feather.metadata.BouncingTargetMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.metadata.MethodMetadataBuilder;
import org.parchmentmc.feather.metadata.MethodReference;
import org.parchmentmc.feather.named.Named;

class MethodMetadataAdapter
extends TypeAdapter<MethodMetadata> {
    private static final TypeToken<LinkedHashSet<MethodReference>> METHOD_REFERENCE_Set_TOKEN = new TypeToken<LinkedHashSet<MethodReference>>(){};
    private final Gson gson;

    public MethodMetadataAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, MethodMetadata value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name");
        this.gson.toJson((Object)value.getName(), Named.class, out);
        out.name("owner");
        this.gson.toJson((Object)value.getOwner(), Named.class, out);
        out.name("security").value((long)value.getSecuritySpecification());
        out.name("descriptor");
        this.gson.toJson((Object)value.getDescriptor(), Named.class, out);
        out.name("signature");
        this.gson.toJson((Object)value.getSignature(), Named.class, out);
        out.name("lambda").value(value.isLambda());
        if (value.getBouncingTarget().isPresent()) {
            out.name("bouncingTarget");
            this.gson.toJson(value.getBouncingTarget().get(), BouncingTargetMetadata.class, out);
        }
        if (value.getParent().isPresent()) {
            out.name("parent");
            this.gson.toJson(value.getParent().get(), MethodReference.class, out);
        }
        if (!value.getOverrides().isEmpty()) {
            out.name("overrides");
            this.gson.toJson((Object)value.getOverrides(), METHOD_REFERENCE_Set_TOKEN.getType(), out);
        }
        if (value.getStartLine().isPresent()) {
            out.name("startLine");
            out.value((Number)value.getStartLine().orElse(0));
        }
        if (value.getEndLine().isPresent()) {
            out.name("endLine");
            out.value((Number)value.getEndLine().orElse(0));
        }
        out.endObject();
    }

    public MethodMetadata read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Named name = Named.empty();
        Named owner = Named.empty();
        int security = -1;
        Named descriptor = Named.empty();
        Named signature = Named.empty();
        boolean lambda = false;
        BouncingTargetMetadata bouncingTarget = null;
        LinkedHashSet overrides = null;
        int startLine = 0;
        int endLine = 0;
        MethodReference parent = null;
        in.beginObject();
        block26: while (in.hasNext()) {
            String propertyName;
            switch (propertyName = in.nextName()) {
                case "name": {
                    name = (Named)this.gson.fromJson(in, Named.class);
                    continue block26;
                }
                case "owner": {
                    owner = (Named)this.gson.fromJson(in, Named.class);
                    continue block26;
                }
                case "security": {
                    security = in.nextInt();
                    continue block26;
                }
                case "descriptor": {
                    descriptor = (Named)this.gson.fromJson(in, Named.class);
                    continue block26;
                }
                case "signature": {
                    signature = (Named)this.gson.fromJson(in, Named.class);
                    continue block26;
                }
                case "lambda": {
                    lambda = in.nextBoolean();
                    continue block26;
                }
                case "bouncingTarget": {
                    bouncingTarget = (BouncingTargetMetadata)this.gson.fromJson(in, BouncingTargetMetadata.class);
                    continue block26;
                }
                case "parent": {
                    parent = (MethodReference)this.gson.fromJson(in, MethodReference.class);
                    continue block26;
                }
                case "overrides": {
                    overrides = (LinkedHashSet)this.gson.fromJson(in, METHOD_REFERENCE_Set_TOKEN.getType());
                    continue block26;
                }
                case "startLine": {
                    startLine = in.nextInt();
                    continue block26;
                }
                case "endLine": {
                    endLine = in.nextInt();
                    continue block26;
                }
            }
            in.skipValue();
        }
        in.endObject();
        if (name.isEmpty()) {
            throw new JsonParseException("Method metadata name is not present or empty");
        }
        if (owner.isEmpty()) {
            throw new JsonParseException("Method metadata owner is not present or empty");
        }
        if (descriptor.isEmpty()) {
            throw new JsonParseException("Method metadata descriptor is not present or empty");
        }
        if (security == -1) {
            throw new JsonParseException("Method metadata security specification is not present");
        }
        if (overrides == null) {
            overrides = new LinkedHashSet();
        }
        if (startLine < 0) {
            throw new JsonParseException("Method metadata contains negative start line");
        }
        if (endLine < 0) {
            throw new JsonParseException("Method metadata contains negative end line");
        }
        if (endLine < startLine) {
            throw new JsonParseException("Method metadata contains end before start");
        }
        return MethodMetadataBuilder.create().withBouncingTarget(bouncingTarget).withName(name).withOwner(owner).withDescriptor(descriptor).withSignature(signature).withSecuritySpecification(security).withParent(parent).withOverrides(overrides).withStartLine(startLine).withEndLine(endLine).withLambda(lambda).build();
    }
}

