/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson.metadata;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.parchmentmc.feather.metadata.ClassMetadata;
import org.parchmentmc.feather.metadata.ClassMetadataBuilder;
import org.parchmentmc.feather.metadata.FieldMetadata;
import org.parchmentmc.feather.metadata.MethodMetadata;
import org.parchmentmc.feather.named.Named;

class ClassMetadataAdapter
extends TypeAdapter<ClassMetadata> {
    private static final TypeToken<LinkedHashSet<Named>> NAMED_Set_TOKEN = new TypeToken<LinkedHashSet<Named>>(){};
    private static final TypeToken<LinkedHashSet<MethodMetadata>> METHOD_METADATA_Set_TOKEN = new TypeToken<LinkedHashSet<MethodMetadata>>(){};
    private static final TypeToken<LinkedHashSet<FieldMetadata>> FIELD_METADATA_Set_TOKEN = new TypeToken<LinkedHashSet<FieldMetadata>>(){};
    private static final TypeToken<LinkedHashSet<ClassMetadata>> CLASS_METADATA_Set_TOKEN = new TypeToken<LinkedHashSet<ClassMetadata>>(){};
    private final Gson gson;

    public ClassMetadataAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, ClassMetadata value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("name");
        this.gson.toJson((Object)value.getName(), Named.class, out);
        out.name("owner");
        this.gson.toJson((Object)value.getOwner(), Named.class, out);
        out.name("security").value((long)value.getSecuritySpecification());
        out.name("extends");
        this.gson.toJson((Object)value.getSuperName(), Named.class, out);
        out.name("implements");
        this.gson.toJson((Object)value.getInterfaces(), NAMED_Set_TOKEN.getType(), out);
        out.name("fields");
        this.gson.toJson((Object)value.getFields(), FIELD_METADATA_Set_TOKEN.getType(), out);
        out.name("methods");
        this.gson.toJson((Object)value.getMethods(), METHOD_METADATA_Set_TOKEN.getType(), out);
        out.name("inner");
        this.gson.toJson((Object)value.getInnerClasses(), CLASS_METADATA_Set_TOKEN.getType(), out);
        out.name("signature");
        this.gson.toJson((Object)value.getSignature(), Named.class, out);
        out.endObject();
    }

    public ClassMetadata read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Named name = Named.empty();
        Named owner = Named.empty();
        int security = -1;
        Named superName = Named.empty();
        LinkedHashSet interfaces = null;
        LinkedHashSet fields = null;
        LinkedHashSet methods = null;
        LinkedHashSet innerClasses = null;
        Named signature = Named.empty();
        in.beginObject();
        block22: while (in.hasNext()) {
            String propertyName;
            switch (propertyName = in.nextName()) {
                case "name": {
                    name = (Named)this.gson.fromJson(in, Named.class);
                    continue block22;
                }
                case "owner": {
                    owner = (Named)this.gson.fromJson(in, Named.class);
                    continue block22;
                }
                case "security": {
                    security = in.nextInt();
                    continue block22;
                }
                case "extends": {
                    superName = (Named)this.gson.fromJson(in, Named.class);
                    continue block22;
                }
                case "implements": {
                    interfaces = (LinkedHashSet)this.gson.fromJson(in, NAMED_Set_TOKEN.getType());
                    continue block22;
                }
                case "fields": {
                    fields = (LinkedHashSet)this.gson.fromJson(in, FIELD_METADATA_Set_TOKEN.getType());
                    continue block22;
                }
                case "methods": {
                    methods = (LinkedHashSet)this.gson.fromJson(in, METHOD_METADATA_Set_TOKEN.getType());
                    continue block22;
                }
                case "inner": {
                    innerClasses = (LinkedHashSet)this.gson.fromJson(in, CLASS_METADATA_Set_TOKEN.getType());
                    continue block22;
                }
                case "signature": {
                    signature = (Named)this.gson.fromJson(in, Named.class);
                    continue block22;
                }
            }
            in.skipValue();
        }
        in.endObject();
        if (name.isEmpty()) {
            throw new JsonParseException("Class metadata name is not present or empty");
        }
        if (security == -1) {
            throw new JsonParseException("Class metadata security specification is not present");
        }
        if (interfaces == null) {
            methods = new LinkedHashSet();
        }
        if (fields == null) {
            methods = new LinkedHashSet();
        }
        if (methods == null) {
            methods = new LinkedHashSet();
        }
        if (innerClasses == null) {
            innerClasses = new LinkedHashSet();
        }
        return ClassMetadataBuilder.create().withSuperName(superName).withInterfaces((Set)interfaces).withOwner(owner).withMethods((Set)methods).withFields((Set)fields).withInnerClasses(innerClasses).withName(name).withSecuritySpecifications(security).withSignature(signature).build();
    }
}

