/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.parchmentmc.feather.named.Named;
import org.parchmentmc.feather.named.NamedBuilder;

public class NamedAdapter
extends TypeAdapter<Named> {
    public void write(JsonWriter out, Named value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        for (Map.Entry schemaNameEntry : value.getNames().entrySet()) {
            out.name((String)schemaNameEntry.getKey()).value((String)schemaNameEntry.getValue());
        }
        out.endObject();
    }

    public Named read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        NamedBuilder builder = NamedBuilder.create();
        in.beginObject();
        while (in.hasNext()) {
            builder.with(in.nextName(), in.nextString());
        }
        in.endObject();
        return builder.build();
    }
}

