/*
 * Decompiled with CFR 0.152.
 */
package org.parchmentmc.feather.io.gson;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.parchmentmc.feather.mapping.ImmutableMappingDataContainer;
import org.parchmentmc.feather.mapping.ImmutableVersionedMappingDataContainer;
import org.parchmentmc.feather.mapping.MappingDataContainer;
import org.parchmentmc.feather.mapping.VersionedMappingDataContainer;
import org.parchmentmc.feather.util.SimpleVersion;

public class MDCGsonAdapterFactory
implements TypeAdapterFactory {
    private final boolean ignoreNonDocumented;
    static final TypeToken<List<String>> STRING_LIST_TOKEN = new TypeToken<List<String>>(){};

    public MDCGsonAdapterFactory(boolean ignoreNonDocumented) {
        this.ignoreNonDocumented = ignoreNonDocumented;
    }

    public MDCGsonAdapterFactory() {
        this(false);
    }

    public boolean isIgnoreNonDocumented() {
        return this.ignoreNonDocumented;
    }

    public <T> @Nullable TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        WildcardType wildcard;
        Type type = typeToken.getType();
        if (type instanceof WildcardType && (wildcard = (WildcardType)type).getUpperBounds().length == 1) {
            type = wildcard.getUpperBounds()[0];
        }
        if (type.equals(VersionedMappingDataContainer.class)) {
            return new VersionedMappingDataContainerAdapter(gson).nullSafe();
        }
        if (type.equals(MappingDataContainer.PackageData.class)) {
            return new PackageDataAdapter(gson, this.ignoreNonDocumented).nullSafe();
        }
        if (type.equals(MappingDataContainer.ClassData.class)) {
            return new ClassDataAdapter(gson, this.ignoreNonDocumented).nullSafe();
        }
        if (type.equals(MappingDataContainer.FieldData.class)) {
            return new FieldDataAdapter(gson, this.ignoreNonDocumented).nullSafe();
        }
        if (type.equals(MappingDataContainer.MethodData.class)) {
            return new MethodDataAdapter(gson, this.ignoreNonDocumented).nullSafe();
        }
        if (type.equals(MappingDataContainer.ParameterData.class)) {
            return new ParameterDataAdapter(this.ignoreNonDocumented).nullSafe();
        }
        return null;
    }

    static class ParameterDataAdapter
    extends TypeAdapter<MappingDataContainer.ParameterData> {
        private final boolean ignoreNonDocumented;

        ParameterDataAdapter(boolean ignoreNonDocumented) {
            this.ignoreNonDocumented = ignoreNonDocumented;
        }

        public void write(JsonWriter writer, MappingDataContainer.ParameterData packageData) throws IOException {
            if (this.ignoreNonDocumented && packageData.getName() == null && packageData.getJavadoc() == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject().name("index").value((long)packageData.getIndex());
            if (packageData.getName() != null) {
                writer.name("name").value(packageData.getName());
            }
            if (packageData.getJavadoc() != null) {
                writer.name("javadoc").value(packageData.getJavadoc());
            }
            writer.endObject();
        }

        public MappingDataContainer.ParameterData read(JsonReader reader) throws IOException {
            byte index = -1;
            String name = null;
            String javadoc = null;
            reader.beginObject();
            block10: while (reader.hasNext()) {
                String propertyName;
                switch (propertyName = reader.nextName()) {
                    case "index": {
                        index = (byte)reader.nextInt();
                        continue block10;
                    }
                    case "name": {
                        name = reader.nextString();
                        continue block10;
                    }
                    case "javadoc": {
                        javadoc = reader.nextString();
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (index < 0) {
                throw new IllegalArgumentException("Parameter index must be present and positive");
            }
            return new ImmutableMappingDataContainer.ImmutableParameterData(index, name, javadoc);
        }
    }

    static class MethodDataAdapter
    extends TypeAdapter<MappingDataContainer.MethodData> {
        static final TypeToken<Collection<? extends MappingDataContainer.ParameterData>> PARAMETER_DATA_COLLECTION = new TypeToken<Collection<? extends MappingDataContainer.ParameterData>>(){};
        private final Gson gson;
        private final boolean ignoreNonDocumented;

        MethodDataAdapter(Gson gson, boolean ignoreNonDocumented) {
            this.gson = gson;
            this.ignoreNonDocumented = ignoreNonDocumented;
        }

        public void write(JsonWriter writer, MappingDataContainer.MethodData methodData) throws IOException {
            JsonElement params = this.gson.getAdapter(PARAMETER_DATA_COLLECTION).toJsonTree((Object)methodData.getParameters());
            if (this.ignoreNonDocumented && methodData.getJavadoc().isEmpty() && (params == null || params instanceof JsonArray && params.getAsJsonArray().size() == 0)) {
                writer.nullValue();
                return;
            }
            writer.beginObject().name("name").value(methodData.getName()).name("descriptor").value(methodData.getDescriptor());
            if (!methodData.getJavadoc().isEmpty()) {
                writer.name("javadoc");
                this.gson.getAdapter(STRING_LIST_TOKEN).write(writer, (Object)methodData.getJavadoc());
            }
            if (!methodData.getParameters().isEmpty()) {
                writer.name("parameters");
                this.gson.toJson(params, writer);
            }
            writer.endObject();
        }

        public MappingDataContainer.MethodData read(JsonReader reader) throws IOException {
            String name = null;
            String descriptor = null;
            List javadoc = null;
            Collection<Object> parameters = null;
            reader.beginObject();
            block12: while (reader.hasNext()) {
                String propertyName;
                switch (propertyName = reader.nextName()) {
                    case "name": {
                        name = reader.nextString();
                        continue block12;
                    }
                    case "descriptor": {
                        descriptor = reader.nextString();
                        continue block12;
                    }
                    case "javadoc": {
                        javadoc = (List)this.gson.getAdapter(STRING_LIST_TOKEN).read(reader);
                        continue block12;
                    }
                    case "parameters": {
                        parameters = (Collection)this.gson.getAdapter(PARAMETER_DATA_COLLECTION).read(reader);
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (name == null) {
                throw new IllegalArgumentException("Field name must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Field descriptor must not be null");
            }
            if (javadoc == null) {
                javadoc = Collections.emptyList();
            }
            if (parameters == null) {
                parameters = Collections.emptyList();
            }
            return new ImmutableMappingDataContainer.ImmutableMethodData(name, descriptor, javadoc, parameters);
        }
    }

    static class FieldDataAdapter
    extends TypeAdapter<MappingDataContainer.FieldData> {
        private final Gson gson;
        private final boolean ignoreNonDocumented;

        FieldDataAdapter(Gson gson, boolean ignoreNonDocumented) {
            this.gson = gson;
            this.ignoreNonDocumented = ignoreNonDocumented;
        }

        public void write(JsonWriter writer, MappingDataContainer.FieldData fieldName) throws IOException {
            if (this.ignoreNonDocumented && fieldName.getJavadoc().isEmpty()) {
                writer.nullValue();
                return;
            }
            writer.beginObject().name("name").value(fieldName.getName()).name("descriptor").value(fieldName.getDescriptor());
            if (!fieldName.getJavadoc().isEmpty()) {
                writer.name("javadoc");
                this.gson.getAdapter(STRING_LIST_TOKEN).write(writer, (Object)fieldName.getJavadoc());
            }
            writer.endObject();
        }

        public MappingDataContainer.FieldData read(JsonReader reader) throws IOException {
            String name = null;
            String descriptor = null;
            List javadoc = null;
            reader.beginObject();
            block10: while (reader.hasNext()) {
                String propertyName;
                switch (propertyName = reader.nextName()) {
                    case "name": {
                        name = reader.nextString();
                        continue block10;
                    }
                    case "descriptor": {
                        descriptor = reader.nextString();
                        continue block10;
                    }
                    case "javadoc": {
                        javadoc = (List)this.gson.getAdapter(STRING_LIST_TOKEN).read(reader);
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (name == null) {
                throw new IllegalArgumentException("Field name must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Field descriptor must not be null");
            }
            if (javadoc == null) {
                javadoc = Collections.emptyList();
            }
            return new ImmutableMappingDataContainer.ImmutableFieldData(name, descriptor, javadoc);
        }
    }

    static class ClassDataAdapter
    extends TypeAdapter<MappingDataContainer.ClassData> {
        static final TypeToken<Collection<? extends MappingDataContainer.FieldData>> FIELD_DATA_COLLECTION = new TypeToken<Collection<? extends MappingDataContainer.FieldData>>(){};
        static final TypeToken<Collection<? extends MappingDataContainer.MethodData>> METHOD_DATA_COLLECTION = new TypeToken<Collection<? extends MappingDataContainer.MethodData>>(){};
        private final Gson gson;
        private final boolean ignoreNonDocumented;

        ClassDataAdapter(Gson gson, boolean ignoreNonDocumented) {
            this.gson = gson;
            this.ignoreNonDocumented = ignoreNonDocumented;
        }

        public void write(JsonWriter writer, MappingDataContainer.ClassData classData) throws IOException {
            JsonElement fields = this.gson.getAdapter(FIELD_DATA_COLLECTION).toJsonTree((Object)classData.getFields());
            JsonElement methods = this.gson.getAdapter(METHOD_DATA_COLLECTION).toJsonTree((Object)classData.getMethods());
            if (this.ignoreNonDocumented && classData.getJavadoc().isEmpty() && (fields == null || fields instanceof JsonArray && fields.getAsJsonArray().size() == 0) && (methods == null || methods instanceof JsonArray && methods.getAsJsonArray().size() == 0)) {
                writer.nullValue();
                return;
            }
            writer.beginObject().name("name").value(classData.getName());
            if (!classData.getJavadoc().isEmpty()) {
                writer.name("javadoc");
                this.gson.getAdapter(STRING_LIST_TOKEN).write(writer, (Object)classData.getJavadoc());
            }
            if (!classData.getFields().isEmpty()) {
                writer.name("fields");
                this.gson.toJson(fields, writer);
            }
            if (!classData.getMethods().isEmpty()) {
                writer.name("methods");
                this.gson.toJson(methods, writer);
            }
            writer.endObject();
        }

        public MappingDataContainer.ClassData read(JsonReader reader) throws IOException {
            String name = null;
            List javadoc = null;
            Collection<Object> fields = null;
            Collection<Object> methods = null;
            reader.beginObject();
            block12: while (reader.hasNext()) {
                String propertyName;
                switch (propertyName = reader.nextName()) {
                    case "name": {
                        name = reader.nextString();
                        continue block12;
                    }
                    case "javadoc": {
                        javadoc = (List)this.gson.getAdapter(STRING_LIST_TOKEN).read(reader);
                        continue block12;
                    }
                    case "fields": {
                        fields = (Collection)this.gson.getAdapter(FIELD_DATA_COLLECTION).read(reader);
                        continue block12;
                    }
                    case "methods": {
                        methods = (Collection)this.gson.getAdapter(METHOD_DATA_COLLECTION).read(reader);
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (name == null) {
                throw new IllegalArgumentException("Class name must not be null");
            }
            if (javadoc == null) {
                javadoc = Collections.emptyList();
            }
            if (fields == null) {
                fields = Collections.emptyList();
            }
            if (methods == null) {
                methods = Collections.emptyList();
            }
            return new ImmutableMappingDataContainer.ImmutableClassData(name, javadoc, fields, methods);
        }
    }

    static class PackageDataAdapter
    extends TypeAdapter<MappingDataContainer.PackageData> {
        private final Gson gson;
        private final boolean ignoreNonDocumented;

        PackageDataAdapter(Gson gson, boolean ignoreNonDocumented) {
            this.gson = gson;
            this.ignoreNonDocumented = ignoreNonDocumented;
        }

        public void write(JsonWriter writer, MappingDataContainer.PackageData packageData) throws IOException {
            if (this.ignoreNonDocumented && packageData.getJavadoc().isEmpty()) {
                writer.nullValue();
                return;
            }
            writer.beginObject().name("name").value(packageData.getName());
            if (!packageData.getJavadoc().isEmpty()) {
                writer.name("javadoc");
                this.gson.getAdapter(STRING_LIST_TOKEN).write(writer, (Object)packageData.getJavadoc());
            }
            writer.endObject();
        }

        public MappingDataContainer.PackageData read(JsonReader reader) throws IOException {
            String name = null;
            List javadoc = null;
            reader.beginObject();
            block8: while (reader.hasNext()) {
                String propertyName;
                switch (propertyName = reader.nextName()) {
                    case "name": {
                        name = reader.nextString();
                        continue block8;
                    }
                    case "javadoc": {
                        javadoc = (List)this.gson.getAdapter(STRING_LIST_TOKEN).read(reader);
                        continue block8;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (name == null) {
                throw new IllegalArgumentException("Package name must not be null");
            }
            if (javadoc == null) {
                javadoc = Collections.emptyList();
            }
            return new ImmutableMappingDataContainer.ImmutablePackageData(name, javadoc);
        }
    }

    static class VersionedMappingDataContainerAdapter
    extends TypeAdapter<VersionedMappingDataContainer> {
        static final TypeToken<Collection<? extends MappingDataContainer.PackageData>> PACKAGE_DATA_COLLECTION = new TypeToken<Collection<? extends MappingDataContainer.PackageData>>(){};
        static final TypeToken<Collection<? extends MappingDataContainer.ClassData>> CLASS_DATA_COLLECTION = new TypeToken<Collection<? extends MappingDataContainer.ClassData>>(){};
        private final Gson gson;

        VersionedMappingDataContainerAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter writer, VersionedMappingDataContainer value) throws IOException {
            writer.beginObject();
            writer.name("version");
            this.gson.getAdapter(SimpleVersion.class).write(writer, (Object)value.getFormatVersion());
            writer.name("packages");
            this.gson.getAdapter(PACKAGE_DATA_COLLECTION).write(writer, (Object)value.getPackages());
            writer.name("classes");
            this.gson.getAdapter(CLASS_DATA_COLLECTION).write(writer, (Object)value.getClasses());
            writer.endObject();
        }

        public VersionedMappingDataContainer read(JsonReader reader) throws IOException {
            SimpleVersion version = null;
            Collection<Object> packages = null;
            Collection<Object> classes = null;
            reader.beginObject();
            block10: while (reader.hasNext()) {
                String propertyName;
                switch (propertyName = reader.nextName()) {
                    case "version": {
                        version = (SimpleVersion)this.gson.getAdapter(SimpleVersion.class).read(reader);
                        if (version == null || version.isCompatibleWith(VersionedMappingDataContainer.CURRENT_FORMAT)) continue block10;
                        throw new JsonParseException("Version " + version + " is incompatible with current version " + VersionedMappingDataContainer.CURRENT_FORMAT);
                    }
                    case "packages": {
                        packages = (Collection)this.gson.getAdapter(PACKAGE_DATA_COLLECTION).read(reader);
                        continue block10;
                    }
                    case "classes": {
                        classes = (Collection)this.gson.getAdapter(CLASS_DATA_COLLECTION).read(reader);
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (packages == null) {
                packages = Collections.emptyList();
            }
            if (classes == null) {
                classes = Collections.emptyList();
            }
            if (version == null) {
                throw new JsonParseException("No version found");
            }
            return new ImmutableVersionedMappingDataContainer(version, packages, classes);
        }
    }
}

